<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://#
 * @since      1.0.0
 *
 * @package    Gpt_Sniper
 * @subpackage Gpt_Sniper/public
 */
/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Gpt_Sniper
 * @subpackage Gpt_Sniper/public
 * @author     gptsniper <admin@gptsniper.com>
 */
class Gpt_Sniper_Public {
	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
       /**
		* Openapi Chatbot Shortcode 
	    */
		add_shortcode('gpt_chatbot', array($this,'gptsniper_openapi_client_chatbot'));
		
		/**
		 * Open Api Q&A Shortcode 
		 */
		add_shortcode('gpt_qa_shortcodes', array($this,'gptsniper_client_qa_widgets'));
		
		/**
		 * Open Api Q&A Footer Widget Shortcode
		 */ 
		add_shortcode('gpt_qa_footer_shortcodes', array($this,'gptsniper_client_footer_qa_widgets')); 

		/**
		 * Image Generator Shortcode
		 */
        add_shortcode('gpt_image_generator_sh', array($this,'gptsniper_image_generator_shortcode')); 
		/**
		 * Content Generator Shortcode
		 */
		add_shortcode('gpt_content_generator_sh', array($this,'gptsniper_content_generator'));  
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Gpt_Sniper_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Gpt_Sniper_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
        wp_enqueue_style('toastr', plugin_dir_url( __FILE__ ) .'css/toastr.min.css', array(), $this->version, 'all');
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/gpt-sniper-public.css', array(), $this->version, 'all' );
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Gpt_Sniper_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Gpt_Sniper_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
        wp_enqueue_script('toastr', plugin_dir_url( __FILE__ ).'js/toastr.min.js', array('jquery'), $this->version, false);
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/gpt-sniper-public.js', array( 'jquery' ), $this->version, false );
        wp_localize_script($this->plugin_name, 'gptsniper_ajax_path', array(
			'url' => admin_url('admin-ajax.php'),
			) 
	    );   
	} 

	/**
	 * Open Api Client Chatbot
	 */
	public function gptsniper_openapi_client_chatbot($atts){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/gpt-sniper-openapi-client-chatbot.php';
    	require_once( plugin_dir_path( dirname( __FILE__ ) ) . 'public/css/color-picker-css.php' );
	}
	
	/**
	 * Open Api Client Q&A Shortcode
	 */
	public function gptsniper_client_qa_widgets($atts){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/gpt-sniper-openapi-client-qa.php';	
	}
	 
	/**
	 * Footer & Section  Q&A Shortcode
	 */ 
	public function gptsniper_client_footer_qa_widgets($atts){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/gpt-sniper-openapi-footer-qa.php';	
	}
    
	/**
	 * Image Generator Shortcode
	 */
	public function gptsniper_image_generator_shortcode(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/gpt-sniper-image-generator.php';	
	}
	/**
	 * Content Generator Shortcode
	 */
	public function gptsniper_content_generator(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/gpt-sniper-content-generator.php';	 
	}
	public function gptsniper_custom_css(){
		require_once( plugin_dir_path( dirname( __FILE__ ) ) . 'public/css/color-picker-css.php' );
	}
}