<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 * 
 * @link               https://themeforest.net/user/kamleshyadav
 * @since             1.0.1
 * @package           Gpt_Sniper
 *
 * @wordpress-plugin
 * Plugin Name:       GPT Sniper
 * Plugin URI:        https://kamleshyadav.com/plugin/gpt-sniper/
 * Description:       GPT Sniper is Chat GPT Website Publisher that Create Set & Forget Websites Directly from Chat GPT on Autopilot Mode in any Niche.
 * Version:           1.0.0
 * Author:            Kamleshyadav
 * Author URI:        https://themeforest.net/user/kamleshyadav
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       gpt-sniper
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'GPT_SNIPER_VERSION', '1.0.1' );
/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-gpt-sniper-activator.php
 */
function activate_gpt_sniper() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-gpt-sniper-activator.php';
	Gpt_Sniper_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-gpt-sniper-deactivator.php
 */
function deactivate_gpt_sniper() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-gpt-sniper-deactivator.php';
	Gpt_Sniper_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_gpt_sniper' );
register_deactivation_hook( __FILE__, 'deactivate_gpt_sniper' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-gpt-sniper.php';

/**
 * Post Type List Get Function Create
 */
if(!function_exists('gptsniper_post_types_lists')){
	function gptsniper_post_types_lists(){
		global $wp_post_types;
		$posttypes = array_keys($wp_post_types);
		$pt_remove = array(
					  "attachment",
					  "nav_menu_item",
					  "customize_changeset",
					  "revision",
					  "custom_css",
					  "oembed_cache",
					  "user_request",
					  "wp_block",
					  "wp_template",
					  "wp_template_part",
					  "wp_global_styles",
					  "wp_navigation"
					);
		if($posttypes):
			foreach($posttypes as $posttype):
				if(in_array($posttype, $pt_remove)) continue;
					$posttype_names[$posttype] = $posttype;
			endforeach;
        endif;
		return $posttype_names;
	}
} 

/** 
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */ 
function run_gpt_sniper() {

	$plugin = new Gpt_Sniper();
	$plugin->run();

}
run_gpt_sniper();
