<?php
$gptsniper_art_file = plugin_dir_path( dirname( __FILE__ ) ) . 'datas/art.json';
$gptsniper_painter_data = file_get_contents($gptsniper_art_file);
$gptsniper_painter_data = json_decode($gptsniper_painter_data, true);
$gptsniper_style_data = file_get_contents($gptsniper_art_file);
$gptsniper_style_data = json_decode($gptsniper_style_data, true);
$gptsniper_photo_file = plugin_dir_path( dirname( __FILE__ ) ) . 'datas/photo.json';
$gptsniper_photo_data = file_get_contents($gptsniper_photo_file);
$gptsniper_photo_data = json_decode($gptsniper_photo_data, true);
?>
<div class="gpt-main-wrapper">
    <div class="gpt-page-content gpt-images-page">
        <div class="gpt-page-title">
          <h1><?php echo esc_html__('Images Generator','gpt-sniper'); ?></h1>
        </div>
        <div class="gpt-content">
            <div class="gpt-with-aside-wrapper">
                <div class="gpt-card gpt-aside-settings">
                    <h4 class="gpt-form-title"><?php echo esc_html__('Image Filter','gpt-sniper'); ?>
                    <a href="<?php echo esc_url('https://kamleshyadav.com/documentation/Codecanyon/gpt-sniper/#imagegenerator'); ?>" target="_blank">
                    <span class="gpt-has-info">
                     <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" x="0" y="0" viewBox="0 0 23.625 23.625" style="enable-background:new 0 0 512 512" xml:space="preserve"><g><g><path d="M11.812,0C5.289,0,0,5.289,0,11.812s5.289,11.813,11.812,11.813s11.813-5.29,11.813-11.813&#10;&#9;&#9;S18.335,0,11.812,0z M14.271,18.307c-0.608,0.24-1.092,0.422-1.455,0.548c-0.362,0.126-0.783,0.189-1.262,0.189&#10;&#9;&#9;c-0.736,0-1.309-0.18-1.717-0.539s-0.611-0.814-0.611-1.367c0-0.215,0.015-0.435,0.045-0.659c0.031-0.224,0.08-0.476,0.147-0.759&#10;&#9;&#9;l0.761-2.688c0.067-0.258,0.125-0.503,0.171-0.731c0.046-0.23,0.068-0.441,0.068-0.633c0-0.342-0.071-0.582-0.212-0.717&#10;&#9;&#9;c-0.143-0.135-0.412-0.201-0.813-0.201c-0.196,0-0.398,0.029-0.605,0.09c-0.205,0.063-0.383,0.12-0.529,0.176l0.201-0.828&#10;&#9;&#9;c0.498-0.203,0.975-0.377,1.43-0.521c0.455-0.146,0.885-0.218,1.29-0.218c0.731,0,1.295,0.178,1.692,0.53&#10;&#9;&#9;c0.395,0.353,0.594,0.812,0.594,1.376c0,0.117-0.014,0.323-0.041,0.617c-0.027,0.295-0.078,0.564-0.152,0.811l-0.757,2.68&#10;&#9;&#9;c-0.062,0.215-0.117,0.461-0.167,0.736c-0.049,0.275-0.073,0.485-0.073,0.626c0,0.356,0.079,0.599,0.239,0.728&#10;&#9;&#9;c0.158,0.129,0.435,0.194,0.827,0.194c0.185,0,0.392-0.033,0.626-0.097c0.232-0.064,0.4-0.121,0.506-0.17L14.271,18.307z&#10;&#9;&#9; M14.137,7.429c-0.353,0.328-0.778,0.492-1.275,0.492c-0.496,0-0.924-0.164-1.28-0.492c-0.354-0.328-0.533-0.727-0.533-1.193&#10;&#9;&#9;c0-0.465,0.18-0.865,0.533-1.196c0.356-0.332,0.784-0.497,1.28-0.497c0.497,0,0.923,0.165,1.275,0.497&#10;&#9;&#9;c0.353,0.331,0.53,0.731,0.53,1.196C14.667,6.703,14.49,7.101,14.137,7.429z" fill="currentColor" /></g></g></svg>
                    <span>
                    <?php echo esc_html__('Click here to know more.','gpt-sniper'); ?>
                    </span>
                    </span>
                    <span class="gpt-read-documention"><?php echo esc_html__('Read Documentation','gpt-sniper'); ?></span>
                    </a>
                    </h4>
                    <div class="gpt-from-wrapper">
                        <!-- Col Two  -->
                        <div class="gpt-col-2">
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_artist">
                            <?php echo esc_html__('Artist','gpt-sniper'); ?>
                            </label>
                            <select name="gpt_image_artist" id="gpt_image_artist">
                                <option value=""><?php echo esc_html__('Select','gpt-sniper'); ?></option>
                                <?php 
                                if($gptsniper_painter_data['painters']):
                                    foreach ($gptsniper_painter_data['painters'] as $key => $value) {
                                        echo '<option value="' . esc_html($value) . '">' . esc_html($value) . '</option>';
                                    }
                                endif;
                                ?>
                            </select>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_style">
                                <?php echo esc_html__('Style','gpt-sniper'); ?>
                            </label>
                            <select name="gpt_image_style" id="gpt_image_style">
                                <option value=""><?php echo esc_html__('Select','gpt-sniper'); ?></option>
                                <?php 
                                if($gptsniper_painter_data['styles']):
                                    foreach ($gptsniper_painter_data['styles'] as $key => $value) {
                                        echo '<option value="' . esc_html($value) . '">' . esc_html($value) . '</option>';
                                    }
                                endif;
                                ?>
                            </select>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_photography">
                                <?php echo esc_html__('Photography','gpt-sniper'); ?>
                            </label>
                            <select name="gpt_image_photography" id="gpt_image_photography">
                            <option value=""><?php echo esc_html__('Select','gpt-sniper'); ?></option>
                            <?php 
                            if($gptsniper_photo_data['photography_style']):
                            foreach($gptsniper_photo_data['photography_style'] as $key => $value) { 
                                echo '<option value="' . esc_html($value) . '">' . esc_html($value) . '</option>';
                            }
                            endif;
                            ?>
                            </select>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_lighting">
                              <?php echo esc_html__('Lighting','gpt-sniper'); ?> 
                            </label>
                            <select name="gpt_image_lighting" id="gpt_image_lighting">
                                <option value=""><?php echo esc_html__('Select','gpt-sniper');?></option>
                                <?php 
                                if($gptsniper_photo_data['lighting']):
                                    foreach ($gptsniper_photo_data['lighting'] as $key => $value) {
                                        echo '<option value="' . esc_html($value) . '">' . esc_html($value) . '</option>';
                                    }
                                endif;
                               ?>
                            </select>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_subject">
                               <?php echo esc_html__('Subject','gpt-sniper'); ?> 
                            </label>
                            <select name="gpt_image_subject" id="gpt_image_subject">
                                <option value=""><?php echo esc_html__('Select','gpt-sniper');?></option>
                                <?php 
                                if($gptsniper_photo_data['subject']):
                                    foreach ($gptsniper_photo_data['subject'] as $key => $value) {
                                        echo '<option value="' . esc_html($value) . '">' . esc_html($value) . '</option>';
                                    }
                                endif;
                               ?>
                            </select>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_Camera">
                              <?php echo esc_html__('Camera','gpt-sniper'); ?>
                            </label>
                            <select name="gpt_image_Camera" id="gpt_image_Camera">
                                <option value=""><?php echo esc_html__('Select','gpt-sniper');?></option>
                                <?php 
                                if($gptsniper_photo_data['camera_settings']):
                                    foreach ($gptsniper_photo_data['camera_settings'] as $key => $value) {
                                        echo '<option value="' . esc_html($value) . '">' . esc_html($value) . '</option>';
                                    }
                                endif;
                               ?>
                            </select>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_composition">
                                <?php echo esc_html__('Composition','gpt-sniper'); ?>
                            </label>
                            <select name="gpt_image_composition" id="gpt_image_composition">
                                <option value=""><?php echo esc_html__('Select','gpt-sniper');?></option>
                                <?php 
                                if($gptsniper_photo_data['composition']):
                                    foreach ($gptsniper_photo_data['composition'] as $key => $value) {
                                        echo '<option value="' . esc_html($value) . '">' . esc_html($value) . '</option>';
                                    }
                                endif;
                               ?>
                            </select>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_images_resolution">
                                <?php echo esc_html__('Resolution','gpt-sniper'); ?>
                            </label>
                            <select name="gpt_images_resolution" id="gpt_images_resolution">
                                <option value=""><?php echo esc_html__('Select','gpt-sniper');?></option>
                                <?php 
                                if($gptsniper_photo_data['resolution']):
                                    foreach ($gptsniper_photo_data['resolution'] as $key => $value) {
                                        echo '<option value="' . esc_html($value) . '">' . esc_html($value) . '</option>';
                                    }
                                endif;
                               ?>
                            </select>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_color">
                                <?php echo esc_html__('Color','gpt-sniper'); ?>
                            </label>
                            <select name="gpt_image_color" id="gpt_image_color">
                                 <option value=""><?php echo esc_html__('Select','gpt-sniper');?></option>
                                <?php 
                                if($gptsniper_photo_data['color']):
                                    foreach ($gptsniper_photo_data['color'] as $key => $value) {
                                        echo '<option value="' . esc_html($value) . '">' . esc_html($value) . '</option>';
                                    }
                                endif;
                               ?>
                            </select>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_effects">
                               <?php echo esc_html__('Special Effects','gpt-sniper'); ?> 
                            </label>
                            <select name="gpt_image_effects" id="gpt_image_effects">
                                <option value=""><?php echo esc_html__('Select','gpt-sniper');?></option>
                                <?php 
                                if($gptsniper_photo_data['special_effects']):
                                    foreach ($gptsniper_photo_data['special_effects'] as $key => $value) {
                                        echo '<option value="' . esc_html($value) . '">' . esc_html($value) . '</option>';
                                    }
                                endif;
                               ?>
                            </select>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_size">
                                <?php echo esc_html__('Size','gpt-sniper'); ?>
                            </label>
                            <select name="gpt_image_size" id="gpt_image_size">
                              <option value="256x256"><?php echo esc_html__('256x256','gpt-sniper'); ?></option>
                              <option value="512x512" selected=""><?php echo esc_html__('512x512','gpt-sniper'); ?></option>
                              <option value="1024x1024"><?php echo esc_html__('1024x1024','gpt-sniper'); ?></option>
                            </select>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_number_of">
                                <?php echo esc_html__('Number Of','gpt-sniper'); ?>
                            </label>
                            <select name="gpt_image_number_of" id="gpt_image_number_of">
                                <option value="1"><?php echo esc_html__('1','gpt-sniper'); ?></option>
                                <option value="2"><?php echo esc_html__('2','gpt-sniper'); ?></option>
                                <option value="3" selected=""><?php echo esc_html__('3','gpt-sniper'); ?></option>
                                <option value="4"><?php echo esc_html__('4','gpt-sniper'); ?></option>
                                <option value="5"><?php echo esc_html__('5','gpt-sniper'); ?></option>
                                <option value="6"><?php echo esc_html__('6','gpt-sniper'); ?></option>
                                <option value="7"><?php echo esc_html__('7','gpt-sniper'); ?></option>
                                <option value="8"><?php echo esc_html__('8','gpt-sniper'); ?></option>
                                <option value="9"><?php echo esc_html__('9','gpt-sniper'); ?></option>
                                <option value="10"><?php echo esc_html__('10','gpt-sniper'); ?></option>
                            </select>
                         </div>
                       </div>
                   </div>
                </div>
                <div class="gpt-card gpt-aside-oppos-content">
                    <h4 class="gpt-form-title"><?php echo esc_html__('Generate Image','gpt-sniper'); ?></h4>
                    <div class="gpt-from-wrapper">
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_generator_sh">
                            <?php echo esc_html__('Shortcode ( Use this shortcode on your webpage)','gpt-sniper'); ?>
                            </label>
                            <div class="gpt-shortcode">
                            <?php echo esc_html__('[gpt_image_generator_sh]','gpt-sniper'); ?>  
                            </div> 
                            <a href="javascript:void(0);" class="copy-button gpt-btn" id="gpt_copy_text">
                            <?php echo esc_html__('Copy Shortcode','gpt-sniper'); ?></a>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_image_uset_input_text">
                            <?php echo esc_html__('Enter Generate Keyword','gpt-sniper'); ?>
                            </label>
                            <input type="text" name="gpt_image_uset_input_text" id="gpt_image_uset_input_text" placeholder="<?php echo esc_attr__('Enter Generate Keyword','gpt-sniper'); ?>" />
                        </div>
                        <div class="gpt-image-results">
                            
                        </div>
                        <div class="gpt-btn-wrapper">
                            <a href="javascript:void(0);" id="gpt_image_generate" class="gpt-btn">
                             <?php echo esc_html__('Generate','gpt-sniper'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div> 
<!-- Loader Section -->
<div class="gpt-preloader">
 <img src="<?php echo plugins_url(); ?>/gpt-sniper/admin/images/gpt-loader.svg" alt="<?php echo esc_attr__('loading','gpt-sniper'); ?>">
 <span><?php echo esc_html__('Please Wait...','gpt-sniper'); ?></span>
</div>    