<?php
/**
 * Auto post schedule
 */
class Auto_post_schedule extends WP_List_Table {

    public function __construct() {
         // Set parent defaults.
         parent::__construct( array(
             'singular' => 'user',     // Singular name of the listed records.
             'plural'   => 'users',    // Plural name of the listed records.
             'ajax'     => true,       // Does this table support ajax?
         ) );
     }
     public function display_data() {
         global $wpdb;
         $gpt_status_data = array();
         $db_table_name = $wpdb->prefix.'schedule_poster';
         $result = $wpdb->get_results("SELECT * FROM $db_table_name");
         if($result){
         foreach($result as $get_data){
             $button_click ='
             <a href="javascript:void(0)"" class="pas-table-btn single_sp_removelist pas-delete-btn pas-tooltip" data-rowid="'.$get_data->sp_id.'" data-text="Remove"> 
                 <svg enable-background="new 0 0 34 34" width="34px" height="34px" version="1.1" viewBox="0 0 34 34" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                 <style type="text/css">
                 .fr4_st0{fill:#f7e5e5;}
                 .fr4_st1{fill-rule:evenodd;clip-rule:evenodd;fill:#ff0000;}
                 </style>
                 <path class="fr4_st0" d="M6,0h22c3.3,0,6,2.7,6,6v22c0,3.3-2.7,6-6,6H6c-3.3,0-6-2.7-6-6V6C0,2.7,2.7,0,6,0z"></path>
                 <path class="fr4_st1" d="m21.4 11.8h-2.3v-0.4c0-0.7-0.5-1.3-1.3-1.3h-1.7c-0.7 0-1.3 0.6-1.3 1.3v0.4h-2.3c-0.6 0-1.1 0.5-1.1 1.1v0.9c0 0.2 0.2 0.4 0.4 0.4h10.2c0.2 0 0.4-0.2 0.4-0.4v-0.9c0.1-0.6-0.4-1.1-1-1.1zm-5.7-0.5c0-0.2 0.2-0.4 0.4-0.4h1.7c0.2 0 0.4 0.2 0.4 0.4v0.4h-2.5v-0.4zm-3.4 3.7c-0.1 0-0.1 0.1-0.1 0.1l0.3 7.6c0 0.7 0.6 1.2 1.3 1.2h6.4c0.7 0 1.3-0.6 1.3-1.2l0.3-7.6c0-0.1-0.1-0.1-0.1-0.1h-9.4zm6.4 1.1c0-0.2 0.2-0.4 0.4-0.4s0.4 0.2 0.4 0.4v5.7c0 0.2-0.2 0.4-0.4 0.4s-0.4-0.2-0.4-0.4v-5.7zm-2.1 0c0-0.2 0.2-0.4 0.4-0.4s0.4 0.2 0.4 0.4v5.7c0 0.2-0.2 0.4-0.4 0.4s-0.4-0.2-0.4-0.4v-5.7zm-2.1 0c0-0.2 0.2-0.4 0.4-0.4s0.4 0.2 0.4 0.4v5.7c0 0.2-0.2 0.4-0.4 0.4s-0.4-0.2-0.4-0.4v-5.7z"></path>
                 </svg>
             </a>';
            $duration = '';
            if(!empty($get_data->sp_time_duration)):
                $duration = "Every ".$get_data->sp_time_duration." days";
            else:
                $duration = $get_data->sp_date_time;
            endif;
            $gpt_status_data[] = array(
                 'ID' => $get_data->sp_id, 
                 'schedule_name' => $get_data->sp_schedule_name,   
                 'Keywords' => $get_data->sp_keywords,  
                 'sp_time_duration' => $duration,
                 'sp_action' => $button_click,
                );  	
         }
            return $gpt_status_data;	
         }else{
            return $gpt_status_data; 
         }
    }
    public function no_items() {
       _e( 'No users avaliable.', 'gpt-sniper' );
    }
    public function get_columns() {
        $columns = array(
            'cb' => '',//'<input type="checkbox" />', 
            'schedule_name' => esc_html__('Schedule Name','gpt-sniper'),
            'Keywords' => esc_html__('Post Title','gpt-sniper'),
            'sp_time_duration' => esc_html__('Time Duration','gpt-sniper'),
            'sp_action' => esc_html__('Actions', 'gpt-sniper' ),
            );
        return $columns; 
    }  
    protected function get_sortable_columns() {
        $sortable_columns = array(
             'schedule_name' => array('schedule_name',true),
             'Keywords'  => array('Keywords', false ),
             'sp_time_duration' => array('sp_time_duration', false )
            ); 
        return $sortable_columns;
    }
    protected function column_default( $item, $column_name ) {
         switch ( $column_name ) {
            case 'schedule_name':
                return $item[ $column_name ];
                break;
            case 'Keywords':
                 return $item[ $column_name ];
                 break;
            case 'sp_time_duration':
                 return $item[ $column_name ];
                 break;
            case 'sp_action':
                 return $item[ $column_name ];
                 break;
        }
    }
    protected function column_cb( $item ) {
    }
    protected function column_title( $item ) {
         $page = wp_unslash( $_REQUEST['page'] ); // WPCS: Input var ok.
         // Build edit row action.
         $edit_query_args = array(
             'page'   => $page,
             'action' => 'edit',
             'user'  => $item['ID'],
         );
 
         $actions['edit'] = sprintf(
             '<a href="%1$s">%2$s</a>',
             esc_url( wp_nonce_url( add_query_arg( $edit_query_args, 'admin.php' ), 'edituser_' . $item['ID'] ) ),
             _x( 'Edit', 'row action','gpt-sniper')
         );
 
         // Build delete row action.
         $delete_query_args = array(
             'page'   => $page,
             'action' => 'delete',
             'user'  => $item['ID'],
         );
 
         $actions['delete'] = sprintf(
             '<a href="%1$s">%2$s</a>',
             esc_url( wp_nonce_url( add_query_arg( $delete_query_args, 'admin.php' ), 'deleteuser_' . $item['ID'] ) ),
             _x( 'Delete', 'row action','gpt-sniper')
         );
 
         // Return the ip_block contents.
         return sprintf( '%1$s %2$s',
             $item['Keywords'],
             $this->row_actions( $actions )
         );
    }
    protected function get_bulk_actions() {
        $actions = '';
        return $actions;
    }
    protected function process_bulk_action() {
         // Detect when a bulk action is being triggered.
         if ( 'delete' === $this->current_action() ) {
             if(is_array($_GET['user'])){
                 foreach ($_GET['user'] as $value) {
                     wp_delete_post($value);
                 }
             }else{
                 wp_delete_post($_GET['user']);
             }
         }
 
         // Edit when a bulk action is being triggered.
         if ( 'edit' === $this->current_action() ) {
             $this->single_row_edit();
             
         }
    } 
    function single_row_edit() {
         require dirname( __FILE__ ) . '/user-edit.php';
         wp_die();
    }
    function prepare_items() {
        global $wpdb; //This is used only if making any database queries
        /**
         *First, lets decide how many records per page to show
         */
         $per_page = 20;
         $columns  = $this->get_columns();
         $hidden   = array();
         $sortable = $this->get_sortable_columns();
 
         $this->_column_headers = array( $columns, $hidden, $sortable );
 
         $this->process_bulk_action();
 
         $data = $this->display_data();
 
         usort( $data, array( $this, 'usort_reorder' ) );
 
         $current_page = $this->get_pagenum();
 
         $total_items = count( $data );
 
         $data = array_slice( $data, ( ( $current_page - 1 ) * $per_page ), $per_page );
         $this->items = $data;
 
         $this->set_pagination_args( array(
             'total_items' => $total_items,                     // WE have to calculate the total number of items.
             'per_page'    => $per_page,                        // WE have to determine how many items to show on a page.
             'total_pages' => ceil( $total_items / $per_page ), // WE have to calculate the total number of pages.
         ) );
    } 
    protected function usort_reorder($a, $b) {
         // If no sort, default to title.
         $orderby = !empty($_REQUEST['orderby']) ? wp_unslash($_REQUEST['orderby']) : 'Keywords'; 
         // If no order, default to asc.
         $order = !empty($_REQUEST['order']) ? wp_unslash($_REQUEST['order']) : 'asc'; 
         // Determine sort order.
         $result = strcmp($a[$orderby], $b[$orderby]);
         return ('asc' === $order) ? $result : - $result;
    }
}
?>
<div class="gpt-main-wrapper">
    <div class="gpt-page-content gpt-automatic-posting-page">
        <div class="gpt-page-title">
            <h1><?php echo esc_html__('Automatic Posting','gpt-sniper'); ?></h1>
        </div> 
        <div class="gpt-content">
            <div class="gpt-card">
                    <h4 class="gpt-form-title"><?php echo esc_html__('Schedule Poster','gpt-sniper'); ?>
                        <a href="<?php echo esc_url('https://kamleshyadav.com/documentation/Codecanyon/gpt-sniper/#autoposting'); ?>" target="_blank">
                        <span class="gpt-has-info">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" x="0" y="0" viewBox="0 0 23.625 23.625" style="enable-background:new 0 0 512 512" xml:space="preserve"><g><g><path d="M11.812,0C5.289,0,0,5.289,0,11.812s5.289,11.813,11.812,11.813s11.813-5.29,11.813-11.813&#10;&#9;&#9;S18.335,0,11.812,0z M14.271,18.307c-0.608,0.24-1.092,0.422-1.455,0.548c-0.362,0.126-0.783,0.189-1.262,0.189&#10;&#9;&#9;c-0.736,0-1.309-0.18-1.717-0.539s-0.611-0.814-0.611-1.367c0-0.215,0.015-0.435,0.045-0.659c0.031-0.224,0.08-0.476,0.147-0.759&#10;&#9;&#9;l0.761-2.688c0.067-0.258,0.125-0.503,0.171-0.731c0.046-0.23,0.068-0.441,0.068-0.633c0-0.342-0.071-0.582-0.212-0.717&#10;&#9;&#9;c-0.143-0.135-0.412-0.201-0.813-0.201c-0.196,0-0.398,0.029-0.605,0.09c-0.205,0.063-0.383,0.12-0.529,0.176l0.201-0.828&#10;&#9;&#9;c0.498-0.203,0.975-0.377,1.43-0.521c0.455-0.146,0.885-0.218,1.29-0.218c0.731,0,1.295,0.178,1.692,0.53&#10;&#9;&#9;c0.395,0.353,0.594,0.812,0.594,1.376c0,0.117-0.014,0.323-0.041,0.617c-0.027,0.295-0.078,0.564-0.152,0.811l-0.757,2.68&#10;&#9;&#9;c-0.062,0.215-0.117,0.461-0.167,0.736c-0.049,0.275-0.073,0.485-0.073,0.626c0,0.356,0.079,0.599,0.239,0.728&#10;&#9;&#9;c0.158,0.129,0.435,0.194,0.827,0.194c0.185,0,0.392-0.033,0.626-0.097c0.232-0.064,0.4-0.121,0.506-0.17L14.271,18.307z&#10;&#9;&#9; M14.137,7.429c-0.353,0.328-0.778,0.492-1.275,0.492c-0.496,0-0.924-0.164-1.28-0.492c-0.354-0.328-0.533-0.727-0.533-1.193&#10;&#9;&#9;c0-0.465,0.18-0.865,0.533-1.196c0.356-0.332,0.784-0.497,1.28-0.497c0.497,0,0.923,0.165,1.275,0.497&#10;&#9;&#9;c0.353,0.331,0.53,0.731,0.53,1.196C14.667,6.703,14.49,7.101,14.137,7.429z" fill="currentColor" /></g></g></svg>
                        <span>
                        <?php echo esc_html__('Click here to know more.','gpt-sniper'); ?>
                        </span>
                        </span>
                        <span class="gpt-read-documention"><?php echo esc_html__('Read Documentation','gpt-sniper'); ?></span>
                        </a>
                    </h4>
                    <div class="gpt-from-wrapper">
                        <a href="#" open-modal="createPostModal" class="gpt-btn modal-link">
                         <?php echo esc_html__('Create Schedule','gpt-sniper'); ?>
                        </a>
                        <div class="gpt-table">
                            <!-- ADD TABLE HERE  -->
                            <div class="pas-table-wrap">
                                <form action="" method="get" class="user-form-listing">
                                    <?php 
                                    $list_table = new Auto_post_schedule(); 
                                    $list_table->prepare_items();
                                    ?>
                                    <div class="pas-table-responsive">
                                     <?php $list_table->display(); ?>
                                    </div>    
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<!-- Loader Section -->
<div class="gpt-preloader">
 <img src="<?php echo plugins_url(); ?>/gpt-sniper/admin/images/gpt-loader.svg" alt="<?php echo esc_attr__('loading','gpt-sniper'); ?>">
</div> 
<!-- Create Post Modal  -->
<div id="createPostModal" class="custom-modal">
    <div class="custom-modal-dialog">
        <div class="custom-modal-content">
            <span class="close-modal" close-modal><?php echo esc_html__('X','gpt-sniper'); ?></span>
            <div class="custom-modal-body">
                <div class="custom-modal-inner">
                    <div class="gpt-modal-wrapper">
                        <div class="gpt-input-wrapper">
                            <label for="gpt_scheduler_keywords">
                            <?php echo esc_html__('Enter Your Schedule Name','gpt-sniper'); ?>
                            </label>
                           <input type="text" placeholder="<?php echo esc_attr__('Your Schedule Name','gpt-sniper'); ?>" id="gpt_scheduler_name" name="gpt_scheduler_name"> 
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_scheduler_keywords">
                              <?php echo esc_html__('Enter Your Post Title','gpt-sniper'); ?>
                            </label>
                           <input type="text" placeholder="<?php echo esc_attr__('Write Post Title','gpt-sniper'); ?>" id="gpt_scheduler_keywords" name="gpt_scheduler_keywords">
                        </div>  
                        <h2><?php echo esc_html__('Post Generation Details','gpt-sniper'); ?></h1>
                        <div class="gpt-input-wrapper">
                            <label for="">
                            <?php echo esc_html__('Time Duration','gpt-sniper'); ?>
                            </label>
                            <select name="gpt_post_crontime" id="gpt_post_crontime">
                                <option value="1"><?php echo esc_html__('Every day','gpt-sniper'); ?></option>
                                <option value="2"><?php echo esc_html__('1 Every 2 days','gpt-sniper'); ?></option>
                                <option value="3"><?php echo esc_html__('1 Every 3 days','gpt-sniper'); ?></option>
                                <option value="4"><?php echo esc_html__('1 Every 4 days','gpt-sniper'); ?></option>
                                <option value="5"><?php echo esc_html__('1 Every 5 days','gpt-sniper'); ?></option>
                                <option value="6"><?php echo esc_html__('1 Every 6 days','gpt-sniper'); ?></option>
                                <option value="7"><?php echo esc_html__('1 Every 7 days','gpt-sniper'); ?></option>
                                <option value="8"><?php echo esc_html__('1 Every 8 days','gpt-sniper'); ?></option>
                                <option value="9"><?php echo esc_html__('1 Every 9 days','gpt-sniper'); ?></option>
                                <option value="10"><?php echo esc_html__('1 Every 10 days','gpt-sniper'); ?></option>
                                <option value="11"><?php echo esc_html__('1 Every 11 days','gpt-sniper'); ?></option>
                                <option value="12"><?php echo esc_html__('1 Every 12 days','gpt-sniper'); ?></option>
                                <option value="13"><?php echo esc_html__('1 Every 13 days','gpt-sniper'); ?></option>
                                <option value="14"><?php echo esc_html__('1 Every 14 days','gpt-sniper'); ?></option>
                                <option value="15"><?php echo esc_html__('1 Every 15 days','gpt-sniper'); ?></option>
                            </select>  
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="">
                            <?php echo esc_html__('Post Status','gpt-sniper'); ?>
                            </label>
                            <select name="gpt_post_status" id="gpt_post_status">
                                <option value="publish" selected=""><?php echo esc_html__('Publish','gpt-sniper'); ?></option>
                                <option value="draft"><?php echo esc_html__('Draft','gpt-sniper'); ?></option>
                            </select> 
                        </div>
                        <?php 
                        $general_api = json_decode(get_option('gptsniper_general_api'),true);
                        if(!empty($general_api['api_key'])):
                        ?>
                        <div class="gpt-col-2">
                            <div class="gpt-input-wrapper">
                                <label for="gpt_add_featured_image">
                                 <?php echo esc_html__('Add Featured Image?','gpt-sniper'); ?>
                                </label>
                                <div class="gpt-radio-btn">
                                    <input type="checkbox" class="gpt_add_featured_image" id="gpt_add_featured_image" name="gpt_add_featured_image" value="true">
                                    <label for="gpt_add_featured_image"><span></span></label>
                                </div> 
                            </div>
                        </div>
                        <div class="gpt-col-2">
                            <div class="gpt-input-wrapper">
                                <label for="gpt_add_image">
                                 <?php echo esc_html__('Add Content Image?','gpt-sniper'); ?>
                                </label>
                                <div class="gpt-radio-btn">
                                    <input type="checkbox" class="gpt_add_image" id="gpt_add_image" name="gpt_add_image" value="true">
                                    <label for="gpt_add_image"><span></span></label>
                                </div> 
                            </div>
                        </div>
                        <?php 
                        endif;
                        ?>
                        <div class="gpt-col-2" id="gpt_openai_image_size_data">
                            <div class="gpt-input-wrapper">
                                <label for="gpt_openai_image_size">
                                 <?php echo esc_html__('GPT Image Size','gpt-sniper'); ?>
                                </label>
                                <select name="gpt_openai_image_size" id="gpt_openai_image_size">
                                  <option value="256x256"><?php echo esc_html__('Small (256x256)','gpt-sniper'); ?></option>
                                  <option value="512x512" selected=""><?php echo esc_html__('Medium (512x512)','gpt-sniper'); ?></option>
                                  <option value="1024x1024"><?php echo esc_html__('Big (1024x1024)','gpt-sniper'); ?></option>
                                </select> 
                            </div>
                        </div>
                       
                        <div class="gpt-btn-wrap">
                            <a href="javascript:void(0);" class="gpt-btn" id="gpt_sniper_schedule_save">
                            <?php echo esc_html__('Save','gpt-sniper'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>