<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://#
 * @since      1.0.0
 *
 * @package    Gpt_Sniper
 * @subpackage Gpt_Sniper/admin/partials
 */
$general_api = json_decode(get_option('gptsniper_general_api'),true);
$openai_api_save = '';
if(!empty($general_api['api_key'])):
    $openai_api_save = $general_api['api_key'];
else:
    $openai_api_save = get_option('gpt_open_rendom_api_keys');
endif;
?>   
<!-- This file should primarily consist of HTML with a little bit of PHP. --> 
<div class="gpt-main-wrapper">
    <div class="gpt-page-content gpt-ai-page">
        <div class="gpt-page-title">
            <h1><?php echo esc_html__('GPT Sniper','gpt-sniper'); ?></h1>
        </div>
        <div class="gpt-content has-title">
            <div class="gpt-card">
                <h4 class="gpt-form-title"><?php echo esc_html__('AI Engine Configuration','gpt-sniper'); ?>
                    <a href="<?php echo esc_url('https://kamleshyadav.com/documentation/Codecanyon/gpt-sniper/#settings'); ?>" target="_blank">
                    <span class="gpt-has-info">
                     <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" x="0" y="0" viewBox="0 0 23.625 23.625" style="enable-background:new 0 0 512 512" xml:space="preserve"><g><g><path d="M11.812,0C5.289,0,0,5.289,0,11.812s5.289,11.813,11.812,11.813s11.813-5.29,11.813-11.813&#10;&#9;&#9;S18.335,0,11.812,0z M14.271,18.307c-0.608,0.24-1.092,0.422-1.455,0.548c-0.362,0.126-0.783,0.189-1.262,0.189&#10;&#9;&#9;c-0.736,0-1.309-0.18-1.717-0.539s-0.611-0.814-0.611-1.367c0-0.215,0.015-0.435,0.045-0.659c0.031-0.224,0.08-0.476,0.147-0.759&#10;&#9;&#9;l0.761-2.688c0.067-0.258,0.125-0.503,0.171-0.731c0.046-0.23,0.068-0.441,0.068-0.633c0-0.342-0.071-0.582-0.212-0.717&#10;&#9;&#9;c-0.143-0.135-0.412-0.201-0.813-0.201c-0.196,0-0.398,0.029-0.605,0.09c-0.205,0.063-0.383,0.12-0.529,0.176l0.201-0.828&#10;&#9;&#9;c0.498-0.203,0.975-0.377,1.43-0.521c0.455-0.146,0.885-0.218,1.29-0.218c0.731,0,1.295,0.178,1.692,0.53&#10;&#9;&#9;c0.395,0.353,0.594,0.812,0.594,1.376c0,0.117-0.014,0.323-0.041,0.617c-0.027,0.295-0.078,0.564-0.152,0.811l-0.757,2.68&#10;&#9;&#9;c-0.062,0.215-0.117,0.461-0.167,0.736c-0.049,0.275-0.073,0.485-0.073,0.626c0,0.356,0.079,0.599,0.239,0.728&#10;&#9;&#9;c0.158,0.129,0.435,0.194,0.827,0.194c0.185,0,0.392-0.033,0.626-0.097c0.232-0.064,0.4-0.121,0.506-0.17L14.271,18.307z&#10;&#9;&#9; M14.137,7.429c-0.353,0.328-0.778,0.492-1.275,0.492c-0.496,0-0.924-0.164-1.28-0.492c-0.354-0.328-0.533-0.727-0.533-1.193&#10;&#9;&#9;c0-0.465,0.18-0.865,0.533-1.196c0.356-0.332,0.784-0.497,1.28-0.497c0.497,0,0.923,0.165,1.275,0.497&#10;&#9;&#9;c0.353,0.331,0.53,0.731,0.53,1.196C14.667,6.703,14.49,7.101,14.137,7.429z" fill="currentColor" /></g></g></svg>
                        <span>
                        <?php 
                        echo esc_html__('Click here to know more.','gpt-sniper'); ?>
                        </span>
                    </span>
                    <span class="gpt-read-documention"><?php echo esc_html__('Read Documentation','gpt-sniper'); ?></span>
                  </a>
                 </h4>
                 <div class="gpt-from-wrapper">
                    <div class="gpt_response_massage"></div>
                     <div class="gpt-input-wrapper">
                        <label for="gpt_open_api_key"> 
                         <?php echo esc_html__('API Key','gpt-sniper'); ?>
                         <span><?php echo esc_html__('(Unlock More Features by Adding Your Own API)','gpt-sniper'); ?></span>
                        </label>
                        <input type="text" placeholder="Enter API here" name="gpt_open_api_key" id="gpt_open_api_key" value="<?php if(!empty($general_api['api_key'])): echo esc_attr($general_api['api_key']); endif; ?>"/>
                        <span><?php echo esc_html__('Don\'t know how to grab api key ?','gpt-sniper'); ?> <a href="<?php echo esc_url('https://openai.com/api/'); ?>" target="_blank"><?php echo esc_html__('Click Here','gpt-sniper'); ?></a></span>
                    </div> 
                    <div class="gpt-input-wrapper">
                        <label for="gpt_model_option">
                         <?php echo esc_html__('Model','gpt-sniper'); ?>
                        </label>
                        <select name="gpt_model_option" id="gpt_model_option">

                            <option value="text-davinci-003" <?php if(!empty($general_api['model_option']) && $general_api['model_option']=='text-davinci-003'): echo esc_attr__('selected','gpt-sniper'); endif; ?>><?php echo esc_html__('text-davinci-003','gpt-sniper'); ?></option>

                            <option value="text-curie-001" <?php if(!empty($general_api['model_option']) && $general_api['model_option']=='text-curie-001'): echo esc_attr__('selected','gpt-sniper'); endif; ?>><?php echo esc_html__('text-curie-001','gpt-sniper'); ?></option>

                            <option value="text-babbage-001" <?php if(!empty($general_api['model_option']) && $general_api['model_option']=='text-babbage-001'): echo esc_attr__('selected','gpt-sniper'); endif; ?>><?php echo esc_html__('text-babbage-001','gpt-sniper'); ?></option>

                            <option value="text-ada-001" <?php if(!empty($general_api['model_option']) && $general_api['model_option']=='text-ada-001'): echo esc_attr__('selected','gpt-sniper'); endif; ?>><?php echo esc_html__('text-ada-001','gpt-sniper'); ?></option>         
                        </select>
                    </div>
                     <!-- Col Two  -->
                    <div class="gpt-col-2">
                        <div class="gpt-input-wrapper">
                            <label for="gpt_temperature">
                              <?php echo esc_html__('Temperature','gpt-sniper'); ?>
                            </label>
                            <input type="number" name="gpt_temperature" id="gpt_temperature" value="<?php if(!empty($general_api['temperature'])): echo esc_attr($general_api['temperature']); else: echo esc_attr__('0.7','gpt-sniper'); endif; ?>">
                        </div>
                        <?php 
                        $general_api = json_decode(get_option('gptsniper_general_api'),true);
                        ?>
                        <div class="gpt-input-wrapper">
                            <label for="max_tokens">
                                <?php echo esc_html__('Max Tokens','gpt-sniper'); ?>
                            </label>
                            <input type="number" name="max_tokens" id="max_tokens" value="<?php if(!empty($general_api['max_tokens'])): echo esc_attr($general_api['max_tokens']); else: echo esc_attr__('1000','gpt-sniper'); endif; ?>">
                        </div> 
                        <div class="gpt-input-wrapper">
                            <label for="gpt_top_p">
                            <?php echo esc_html__('Top P','gpt-sniper'); ?>  
                            </label>
                            <input type="number" placeholder="Enter Value" name="gpt_top_p" id="gpt_top_p" value="<?php if(!empty($general_api['top_p'])): echo esc_attr($general_api['top_p']); else: echo esc_attr__('0.01','gpt-sniper'); endif; ?>"/>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_best_of">
                            <?php echo esc_html__('Best Of','gpt-sniper'); ?>  
                            </label>
                            <input type="number" placeholder="Enter Value" name="gpt_best_of" id="gpt_best_of" value="<?php if(!empty($general_api['best_of'])): echo esc_attr($general_api['best_of']); else: echo esc_attr__('1','gpt-sniper'); endif; ?>"/>
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_frequency_penalty">
                             <?php echo esc_html__('Frequency Penalty','gpt-sniper'); ?>    
                            </label>
                            <input type="number" name="gpt_frequency_penalty" id="gpt_frequency_penalty" value="<?php if(!empty($general_api['frequency_penalty'])): echo esc_attr($general_api['frequency_penalty']); else: echo esc_attr__('0.01','gpt-sniper'); endif; ?>">
                           
                        </div>
                        <div class="gpt-input-wrapper">
                            <label for="gpt_presence_penalty">
                              <?php echo esc_html__('Presence Penalty','gpt-sniper'); ?>    
                            </label>
                            <input type="number" name="gpt_presence_penalty" id="gpt_presence_penalty" value="<?php if(!empty($general_api['presence_penalty'])): echo esc_attr($general_api['presence_penalty']); else: echo esc_attr__('0.01','gpt-sniper'); endif; ?>">
                        </div>
                    </div>
                    <div class="gpt-input-wrapper">
                    <label for="<?php echo esc_attr($list_data); ?>">
                     <?php echo esc_html__('Display Content Generator','gpt-sniper'); ?>
                    </label>
                    <div class="gpt-checkbox-group ">
                    <?php
                    $post_list_data = gptsniper_post_types_lists();
                    $screens = array();
                    if(!empty($general_api['post_list_data'])):
                     $screens = explode(",",$general_api['post_list_data']);
                    endif;
                    $i=0;
                    if(!empty($post_list_data)):
                        foreach($post_list_data as $list_data):
                        ?>
                        <div class="gpt-input-wrapper">
                            <label for="<?php echo esc_attr($list_data); ?>"><?php echo esc_html($list_data); ?></label>
                            <div class="gpt-radio-btn">
                                <input type="checkbox" class="gpt_post_types" name="post_type_list[]" id="<?php echo esc_attr($list_data); ?>" value="<?php echo esc_attr($list_data); ?>" <?php if(!empty($screens[$i]) && $screens[$i]==$list_data): echo 'checked'; endif; ?>>
                                <label for="<?php echo esc_attr($list_data); ?>"><span></span></label> 
                            </div>  
                        </div>
                        <?php
                        $i++;
                        endforeach;
                    endif;
                    ?>
                    </div>
                    </div>
                    <div class="gpt-btn-wrapper">
                        <a href="javascript:void(0);" class="gpt-btn" id="gpt_api_save_data">
                           <?php echo esc_html__('Save','gpt-sniper'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Loader Section -->
<div class="gpt-preloader">
<img src="<?php echo plugins_url(); ?>/gpt-sniper/admin/images/gpt-loader.svg" alt="<?php echo esc_attr__('loading','gpt-sniper'); ?>">
</div>  