<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://#
 * @since      1.0.0
 *
 * @package    Gpt_Sniper
 * @subpackage Gpt_Sniper/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Gpt_Sniper
 * @subpackage Gpt_Sniper/admin
 * @author     gptsniper <admin@gptsniper.com>
 */
class Gpt_Sniper_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Gpt_Sniper_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Gpt_Sniper_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
        wp_enqueue_style('toastr', plugin_dir_url( __FILE__ ) .'css/toastr.min.css', array(), $this->version, 'all');
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/gpt-sniper-admin.css', array(), $this->version, 'all' ); 
	}
   
	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Gpt_Sniper_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Gpt_Sniper_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
        wp_enqueue_script('toastr', plugin_dir_url( __FILE__ ).'js/toastr.min.js', array('jquery'), $this->version, false);
  	    wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/gpt-sniper-admin.js', array( 'jquery' ), $this->version, false );
        wp_localize_script($this->plugin_name, 'gptsniper_ajax_path', array(
			'url' => admin_url('admin-ajax.php'),
			) 
	    );  

	}
	
	/**
	 * Gpt Sniper Dashboard Menu Option
	 */
    public function gptsniper_admin_menus(){
    	/**
    	 * Dashboard Menu
    	 */
    	add_menu_page( 
    		esc_html__('GPT Sniper','gpt-sniper'),
    		esc_html__('GPT Sniper','gpt-sniper'),
    		'manage_options',
			'gpt-sniper',
    		 array($this, 'gptsniper_admin_setting'),
			 plugins_url('gpt-sniper/admin/images/gpt-icon.png'), 
    		6
      	  );
        /**
		 * Gpt Settings
		 */
	
		add_submenu_page('gpt-sniper', 
			esc_html__('Settings','gpt-sniper'), 
			esc_html__('Settings','gpt-sniper'), 
			'manage_options', 
			'gpt-settings',
			array($this, 'gptsniper_admin_setting')
		); 
	    /**
		 * Automatic Posting Freature
		 */ 
		 
		add_submenu_page('gpt-sniper', 
			esc_html__('Auto Posting','gpt-sniper'), 
			esc_html__('Auto Posting','gpt-sniper'), 
			'manage_options', 
			'gpt-auto-posting',
			array($this,'gptsniper_chatbot_automatic_posting_freature')
		  ); 
		  
		/**
		 * Gpt Content Writer
		 */	
		add_submenu_page('gpt-sniper', 
			esc_html__('Content Generator','gpt-sniper'), 
			esc_html__('Content Generator','gpt-sniper'), 
			'manage_options', 
			'gpt-content-generator',
			array($this, 'gptsniper_content_writer')
			);
			
		/**
		 * Gpt Sniper Image Generator Menu
		 */ 
		$general_api = json_decode(get_option('gptsniper_general_api'),true);
		if(!empty($general_api['api_key'])):
			add_submenu_page('gpt-sniper', 
			esc_html__('Images Generator','gpt-sniper'), 
			esc_html__('Images Generator','gpt-sniper'), 
			'manage_options', 
			'gpt-images-generator',
			array( $this, 'gptsniper_image_generator')
			);
		endif;
                
		/**
		 * Gpt Sniper Q&A Menu
		 */ 
		add_submenu_page('gpt-sniper', 
		    esc_html__('Q&A','gpt-sniper'), 
		    esc_html__('Q&A','gpt-sniper'), 
	       'manage_options', 
	       'gpt-questionanwser',
	        array( $this, 'gptsniper_questionanwser_option')
		   );

	   /**
		 * Gpt Sniper Q&A Menu
		 */ 
		add_submenu_page('gpt-sniper', 
		esc_html__('User Guide','gpt-sniper'), 
		esc_html__('User Guide','gpt-sniper'), 
			'manage_options', 
			'gpt-user-guide',
			array( $this, 'gptsniper_user_guide_document')
		);
              
		/**
		 * Gpt Sniper Seo Menu
		 */ 
		add_submenu_page('gpt-sniper', 
			esc_html__('SEO','gpt-sniper'), 
			esc_html__('SEO','gpt-sniper'), 
			'manage_options', 
			'gpt-seo',
			array( $this, 'gptsniper_seo_option')
		);
		
		/**
		 * Gpt Sniper Seo Menu
		 */ 
		add_submenu_page('gpt-sniper', 
			esc_html__('Chatbot','gpt-sniper'), 
			esc_html__('Chatbot','gpt-sniper'), 
			'manage_options', 
			'gpt-chatbot',
			array($this, 'gptsniper_chatbot_option')
		  );
        
		/**
		 * Remove duplicate item menu
		 */
		unset($GLOBALS['submenu']['gpt-sniper'][0]);
    }
	
	/**
	 * Generate Featured Image
	 */
	public function gptsniper_generate_featured_image($image_url, $post_id){
	    $upload_dir = wp_upload_dir();
		$image_data = file_get_contents($image_url);
		$filename = basename($image_url);
		if(wp_mkdir_p($upload_dir['path']))
		   $file = $upload_dir['path'] . '/' . $filename;
		else
		   $file = $upload_dir['basedir'] . '/' . $filename;
		file_put_contents($file, $image_data);
	
		$wp_filetype = wp_check_filetype($filename, null );
		$attachment = array(
			'post_mime_type' => $wp_filetype['type'],
			'post_title' => sanitize_file_name($filename),
			'post_content' => '',
			'post_status' => 'inherit'
		);
		$attach_id = wp_insert_attachment( $attachment, $file, $post_id );
		require_once(ABSPATH . 'wp-admin/includes/image.php');
		$attach_data = wp_generate_attachment_metadata( $attach_id, $file );
		$res1= wp_update_attachment_metadata( $attach_id, $attach_data );
		$res2= set_post_thumbnail( $post_id, $attach_id );
	}
	/**
	 * Gpt Sniper User Guide
	 */
	public function gptsniper_user_guide_document(){
	?>
	<div class="gpt-main-wrapper">
		<div class="gpt-page-content">
			<div class="gpt-card">
				<div class="gpt-content">
					<h4 class="gpt-form-title"><?php echo esc_html__('User Guide','gpt-sniper'); ?></h4>
					<div class="gpt-from-wrapper"> 
						<h4 class="gpt-form-title">
							<a href="<?php echo esc_url('https://kamleshyadav.com/documentation/Codecanyon/gpt-sniper/'); ?>" target="_blank">
								<span class="gpt-read-documention">Click to view documentation</span>
							</a>
						</h4>
					</div>
				</div> 
			</div> 
		</div> 
	</div>
	<script>window.open("https://kamleshyadav.com/documentation/Codecanyon/gpt-sniper/", '_blank');</script>;
	<?php
	}
	/**
	 * Content Writer
	 */
	public function gptsniper_content_writer(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/gpt-sniper-content-writer.php';
	}
	/**
	 * Automatic Posting Freature
	 */
	public function gptsniper_chatbot_automatic_posting_freature(){
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/gpt-sniper-automatic-posting.php';
	} 
	/**
	 * Gpt Sniper Dashboard Setting Option
	 */ 
	public function gptsniper_admin_setting(){
	    require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/gpt-sniper-admin-setting.php';
	}
	
	/**
	 * Gpt Sniper Image Generator OPtion
	 */
	public function gptsniper_image_generator(){
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/gpt-sniper-images-ganerator.php';
    }

	/**
	 * Gpt Sniper Seo OPtion
	 */
	public function gptsniper_seo_option(){
       require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/gpt-sniper-seo.php';
	}

	/**
	 * Gpt Sniper Chatbot OPtion
	 */
	public function gptsniper_chatbot_option(){
       require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/gpt-sniper-chatbot.php';
    }

	/**
	 * Gpt Sniper Q&A OPtion
	 */
	public function gptsniper_questionanwser_option(){
       require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/gpt-sniper-questionanwser.php';
	}
		
	/**
	 * Post and Custom Post Meta Box Content Add Setting
	 */
	function gptsniper_add_custom_box() {
		$general_api = json_decode(get_option('gptsniper_general_api'),true);
		$screens = array();
		if(!empty($general_api['post_list_data'])){
			$screens = explode(",",$general_api['post_list_data']);
		}
		foreach ($screens as $screen ) {
			add_meta_box(
				'gptsniper_box_id',                 
				'GPT Sniper AI',      
				array( $this, 'gptsniper_custom_box_html'),  
				$screens                           
			);
		}
	}
	// Meta option Html View
	function gptsniper_custom_box_html($post) {
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/gpt-sniper-meta-box.php';
	}
	function gptsniper_save_postdata($post_id) {

    }   
	/**
	 * Gp Sniper WP Media Image File Ajax
	 */
	public function gptsniper_wp_media_image_fileload(){
		$general_api = json_decode(get_option('gptsniper_general_api'),true);
		$openai_api_save = '';
		if(!empty($general_api['api_key'])):
			$openai_api_save = $general_api['api_key'];
		else:
			$openai_api_save = get_option('gpt_open_rendom_api_keys');
		endif;
		$openai_api = '';
		if(!empty($openai_api_save)):
			$openai_api = esc_html__('active','image-buzz');
		endif;
		$data_keys = ''; 
		if(!empty($_POST['data_keys'])):
			$data_keys = sanitize_text_field($_POST['data_keys']);
		endif;  
		echo '<div class="gpt-top-wrapper">';
			if(!empty($openai_api)):
				echo '<div class="gpt-form-search-image">
					<input type="text" value="'.esc_attr__('','gpt-sniper').'" class="gpt-search-image" name="title" id="gpt-search-images-name" placeholder="'.esc_attr__('Search','gpt-sniper').'">
					<a href="javascript:;" class="gpt-image-find-name gpt-btn buzz-btn" data-type="'.esc_attr__('Unsplash', 'gpt-sniper').'">'.esc_html__('Find Image','gpt-sniper').'</a>
				</div>';
			endif;
		echo '</div>';
		
		echo '<div class="gpt-bottom-wrapper">
				<div class="gpt-media-images">
					<div class="gpt-media-images-ajax row">
					</div>
				</div>
			</div>';
		wp_die();	
	}
	/**
	 * Gpt Sniper Open APi in Image Search
	 */
    public function gptsniper_open_search_image(){
		$data_keys = '';
		if(!empty($_POST['data_keys'])):
		$data_keys = sanitize_text_field($_POST['data_keys']);
		endif;
		$ogj = str_replace(" ","%20",$data_keys);
		if(!empty($_POST['size'])){
			$size = $_POST['size'];
		}else{
			$size = "1024x1024";
		}
		ob_start();
		if(!empty($ogj)){
			$args = array(
				"prompt" => $ogj,
				"n"=>10,
				"size"=>$size
			); 
		$general_api = json_decode(get_option('gptsniper_general_api'),true);
		$openai_api_save = '';
        if(!empty($general_api['api_key'])):
        	$openai_api_save = $general_api['api_key'];
        else:
			$openai_api_save = get_option('gpt_open_rendom_api_keys');
        endif;
		$data_string = json_encode($args);  
		$ch = curl_init('https://api.openai.com/v1/images/generations');
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");                                       
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                         
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Authorization: Bearer '.$openai_api_save,
		'Content-Type: application/json'
		));
		$result = curl_exec($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
		$a = json_decode($result,true);
		if(isset($a['data'])){
			foreach($a['data'] as $a_child){
				$imgUrl = $a_child['url'];
				echo '<div class="gpt-thumb-box">
						<img src="'.esc_url($imgUrl).'" alt="'.esc_attr__('Openai','gpt-sniper').'">
							<div class="gpt-action">
							<a href="javascript:void(0)" data-url="'.base64_encode($imgUrl).'" class="gpt-savemedia-image">
							'. esc_html__('Use','gpt-sniper').' 
							</a>
						</div>
					</div>';  
			}
		}
		else{
			echo '<p>'.esc_html($a['error']['message']).'</p>';
			
			/**
			 * Api key Update
			 */ 
			if(empty($general_api['api_key'])){
				if($httpcode == 429){
					$remot_hit = $this->gptsniper_remote_api_update();
					if($remot_hit){
						$this->gptsniper_open_search_image();
					}
				}
			}

		}
	 }
		else{
			echo '<p>'.esc_html__('Please Enter Object Name.','gpt-sniper').'</p>';
		}
		wp_die();	
	}
	/**
	 * Gpt Sniper Images upload media
	 */ 
	public function gptsniper_upload_save_media(){
		$img_title = '';
		if(!empty($_POST['title'])):
			$img_title = sanitize_text_field($_POST['title']);
		endif;
		$new_image = '';
		if(!empty($_POST['image'])):
		$img = 'openai_images.png'; 
		$get_image_src = base64_decode($_POST['image']);
		file_put_contents($img, file_get_contents($get_image_src));
		$img_url= get_home_url().'/wp-admin/openai_images.png';
		$new_image = sanitize_url($img_url);
		endif; 
		$format = '';
		if(!empty($_POST['fm'])):
		$format = sanitize_text_field($_POST['fm']);
		$new_image = $new_image.'?fm=.'.$format;
		endif;
		$res = $this->gptsniper_set_image_from_url($new_image);
		if($res > 0):
			$value = wp_get_attachment_url($res);
			$data = array('status' => 'true', 'id'=> $res, 'url'=> $value);
			echo json_encode($data);
		else:
			$data = array('status' => 'false','msg'=>esc_html__('Some Thing Went to Wrong!','image-buzz'));
			echo json_encode($data);
		endif;
		wp_die(); 
	}	
	/**
	 * WP Media Libary In Image File Save
	 */
	public function gptsniper_set_image_from_url($url) {
		$tmp = download_url($url);
		$file_array = array(
			'name' => basename( $url ),
			'tmp_name' => $tmp
		);
		if(is_wp_error($tmp)){
			@unlink( $file_array[ 'tmp_name' ] );
			return $tmp;
		}
		$post_id = '0';
		$id = media_handle_sideload( $file_array, $post_id );
		if(is_wp_error($id)){
			@unlink( $file_array['tmp_name']);
			return $id;
		}
		return $id;
	}

	/**
	 * Gpt Sniper Images Generator 
	 */
	public function gptsniper_openai_img_generator() {
		$general_api = json_decode(get_option('gptsniper_general_api'),true);
        $user_key = '';
		if(!empty($general_api['api_key'])):
			$openai_api_save = $general_api['api_key'];
			$user_key ='yes';
		else:
			$user_key ='no';
			$openai_api_save = get_option('gpt_open_rendom_api_keys');
		endif;
		$data_keys = '';
		if(!empty($_POST['data_keys'])):
			$data_keys = sanitize_text_field($_POST['data_keys']);
		endif;
		$image_artist = '';
		if(!empty($_POST['image_artist'])):
			$image_artist = sanitize_text_field($_POST['image_artist']);
		endif;
		$image_style = '';
		if(!empty($_POST['image_style'])):
			$image_style = sanitize_text_field($_POST['image_style']);
		endif;
		$image_photography = '';
		if(!empty($_POST['image_photography'])):
			$image_photography = sanitize_text_field($_POST['image_photography']);
		endif;
		$image_lighting = '';
		if(!empty($_POST['image_lighting'])):
			$image_lighting = sanitize_text_field($_POST['image_lighting']);
		endif;
		$image_subject = '';
		if(!empty($_POST['image_subject'])):
			$image_subject = sanitize_text_field($_POST['image_subject']);
		endif;
		$image_Camera = '';
		if(!empty($_POST['image_Camera'])):
			$image_Camera = sanitize_text_field($_POST['image_Camera']);
		endif;
		$image_composition = '';
		if(!empty($_POST['image_composition'])):
			$image_composition = sanitize_text_field($_POST['image_composition']);
		endif;
		$images_resolution = '';
		if(!empty($_POST['images_resolution'])):
			$images_resolution = sanitize_text_field($_POST['images_resolution']);
		endif;
		$image_color = '';
		if(!empty($_POST['image_color'])):
			$image_color = sanitize_text_field($_POST['image_color']);
		endif;
		$image_effects = '';
		if(!empty($_POST['image_effects'])):
			$image_effects = sanitize_text_field($_POST['image_effects']);
		endif;
		$image_number_of = '';
		if(!empty($_POST['image_number_of'])):
			$image_number_of = sanitize_text_field($_POST['image_number_of']);
		else:
			$image_number_of = 1;
		endif;
		$data_keys = "$data_keys,$image_artist,$image_photography,$image_lighting,$image_subject,$image_Camera,$image_composition,$images_resolution,$image_color,$image_effects";
		$ogj = str_replace(" ","%20",$data_keys);
		
        if(!empty($_POST['image_size'])){
			$size = sanitize_text_field($_POST['image_size']);
		}else{
			$size = "1024x1024";
		}
		
		ob_start();
		if(!empty($ogj)){
			$args = array(
				"prompt" => $ogj,
				"n"=>(int)$image_number_of,
				"size"=>$size
			);    
		$data_string = json_encode($args);  
		$ch = curl_init('https://api.openai.com/v1/images/generations');
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");                                       
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                         
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Authorization: Bearer '.$openai_api_save,
		'Content-Type: application/json'
		));
			$result = curl_exec($ch);
			// Get Status
			$httpcode = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
			$a = json_decode($result,true);  
			if(isset($a['data'])){
				$ij = 1;
				foreach($a['data'] as $a_child){
					$ij = rand();
					$imgUrl = $a_child['url'];
					$img = 'openai_images_'.$ij.'.png'; 
					file_put_contents($img, file_get_contents($imgUrl));
					$img_url= get_home_url().'/wp-admin/openai_images_'.$ij.'.png';
					echo '<div class="gpt-openai-images">
							<img src="'.esc_url($img_url).'" alt="'.esc_attr__('Openai','gpt-sniper').'">
								<div class="gpt-action">
								<a href="javascript:void(0)" data-url="'.esc_url($img_url).'" class="gpt-btn gpt-savemedia-image gpt_download_image" download>'.esc_html__('Download','gpt-sniper').'</a> 
								<a href="'.esc_url($img_url).'" target="_blank" class="gpt-btn">'.esc_html__('View','gpt-sniper').'</a> 
							</div> 
						</div>';   
				}
			}else{
				echo '<p>'.esc_html($a['error']['message']).'</p>';
				
			} 	
		}else{
			echo '<p>'.esc_html($a['error']['message']).'</p>';
		}
		wp_die();
	}
	
	/**
	 * Gpt Sniper General Api Settings Save
	 */
	public function gptsniper_general_api_settings(){
	    
		extract($_POST);
		if(update_option('gptsniper_general_api', json_encode($_POST))){
			echo json_encode(array('status'=>true,'message'=>esc_html__("Saved Successfully","gpt-sniper")));
	
		}else{
			echo json_encode(array('status'=>false,'message'=>esc_html__("Something went to wrong!","gpt-sniper")));
		} 
	    wp_die();	
	}

    /**
	 * Gpt Sniper Content Generator
	 */  
    public function gptsniper_content_generator(){
        $general_api = json_decode(get_option('gptsniper_general_api'),true);
	    $openai_api_save = '';
        $user_key = '';
		if(!empty($general_api['api_key'])):
			$openai_api_save = $general_api['api_key'];
			$user_key ='yes';
		else:
			$user_key ='no';
			$openai_api_save = get_option('gpt_open_rendom_api_keys');
		endif;
		$getMaxTokens = 1000;
		if(!empty($general_api['max_tokens'])):
			$getMaxTokens = $general_api['max_tokens'];
		endif; 
		$getTemperature =0.5;
		if(!empty($general_api['temperature'])):
			$getTemperature = $general_api['temperature'];
		endif;
		$model_option = 'text-davinci-003';
		if(!empty($general_api['model_option'])):
			$model_option = $general_api['model_option'];
		endif;
		$presence_penalty = 0.01;
		if(!empty($general_api['presence_penalty'])): 
			$presence_penalty = $general_api['presence_penalty'];
	    endif;
		$frequency_penalty = 0.01;
		if(!empty($general_api['frequency_penalty'])): 
			$frequency_penalty = $general_api['frequency_penalty'];
	    endif;
		$best_of = 1;
		if(!empty($general_api['best_of'])): 
			$best_of = $general_api['best_of'];
	    endif;
		$top_p = 0.01;
		if(!empty($general_api['top_p'])): 
			$top_p = $general_api['top_p'];
	    endif;
		$TEXT = '';
		if(!empty($_POST['title'])):
		  $TEXT = sanitize_text_field($_POST['title']);
		endif;
		$language = 'english';
		if(!empty($_POST['openai_language'])):
		  $language = sanitize_text_field($_POST['openai_language']);
		endif;
        $media_image_url = '';
		$add_image = '';
		if(!empty($_POST['add_image'])):
		  $add_image = sanitize_text_field($_POST['add_image']);
		endif;
		$feature_image = '';
		if(!empty($_POST['feature_image'])):
		  $feature_image = sanitize_text_field($_POST['feature_image']);
		endif;
		$nopara = '3';
		if(!empty($_POST['number_of_paragraphs'])):
		  $nopara = sanitize_text_field($_POST['number_of_paragraphs']);
		endif;

		if($add_image==='true' || $feature_image==='true'){
			/**
			 * Image Code
			 */
			$ogj = str_replace(" ","%20",$TEXT);
			if(!empty($_POST['feature_image_size'])){
				$size = sanitize_text_field($_POST['feature_image_size']);
			}else{
				$size = "1024x1024";
			}
			if(!empty($ogj)){
				$args = array(
					"prompt" => "$language:$ogj",
					"n"=>1,
					"size"=>$size
				);  
			$data_string = json_encode($args);  
			$ch = curl_init('https://api.openai.com/v1/images/generations');
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");                                       
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                         
			curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Authorization: Bearer '.$openai_api_save,
			'Content-Type: application/json'
			));
			$result = curl_exec($ch);
			$a = json_decode($result,true);
			if(isset($a['data'])){
				foreach($a['data'] as $a_child){
					$img = 'openai_images.png'; 
					$imgUrl = $a_child['url'];
					file_put_contents($img, file_get_contents($imgUrl));
					$img_url= get_home_url().'/wp-admin/openai_images.png';
					$new_image = sanitize_url($img_url);
					$res = $this->gptsniper_set_image_from_url($new_image);
                    if($res > 0):
						$media_image_url = wp_get_attachment_url($res);
						/**
						 * Set Feture Image Option
						 */
						if($feature_image=='true'):
						   $this->bptsniper_setfeature_images_byurl($_POST['post_id'],$media_image_url);
						endif;
                    endif;
				}
			  }
			} 

	    }
       
		/**
		 * Content Code
		 */
		 $large_content = '';
		 $prompt_text_heading = 'informative'.' heading(s) about ';
		 $formatted_prompt = 'write ' . strval( $nopara ) . ' ' . $prompt_text_heading . ' ' . $TEXT . ' in ' . $language . ' language seperated by <momoseperator>';
		 $heading_list = $this->gptsniper_create_heading_lists($formatted_prompt);
		 
		 if(!empty($heading_list['content']) && $heading_list['status'] == 200):
		     $large_content = $this->gptsniper_create_large_content($heading_list['content'],$language);
		 endif;  
		 $postContent = '';
		 $post_edit_url = admin_url().'post.php?post='.$_POST['post_id'].'&action=edit';
		 if($heading_list['status'] == 200){
           $postContent = $large_content['content']; 
		    if($add_image==='true'):
			   $with_image = '<img src="'.esc_url($imgUrl).'" alt='.esc_attr($TEXT).'><br>';
               $postContent = $with_image.' '.$postContent;
			endif;
			$result_data = array('status'=>$heading_list['status'],
		                         'content_data'=> $postContent,
								 'post_url' => $post_edit_url,
				                 'message' => esc_html__('Successfully',"gpt-sniper")
				                 
		                        );
		   update_post_meta($_POST['post_id'], 'gpt_post_content', $postContent );

        }else{
			
			$result_data = array('status'=>$heading_list['status'],
		                         'content_data'=>$postContent,
								 'user_key'=>$user_key,
				                 'message' => esc_html__("Something went to wrong!","gpt-sniper")
		                        );
		               
		}
		echo json_encode($result_data);
	wp_die(); 
    
	}

	/**
	 * Gpt Sniper Set Feature Image by Url
	 */ 
	public function bptsniper_setfeature_images_byurl($post_id=false,$image_url=false){
        $image_name  = 'openai_images.png';
		$upload_dir  = wp_upload_dir(); // Set upload folder
		$image_data  = file_get_contents($image_url); // Get image data
		$unique_file_name = wp_unique_filename( $upload_dir['path'], $image_name ); // Generate unique name
		$filename  = basename( $unique_file_name ); // Create image file name
		// Check folder permission and define file location
		if( wp_mkdir_p( $upload_dir['path'] ) ) {
			$file = $upload_dir['path'] . '/' . $filename;
		} else {
			$file = $upload_dir['basedir'] . '/' . $filename;
		}
		// Create the image  file on the server
		file_put_contents( $file, $image_data );
		$wp_filetype = wp_check_filetype( $filename, null );
		// Set attachment data
		$attachment = array(
			'post_mime_type' => $wp_filetype['type'],
			'post_title'     => sanitize_file_name( $filename ),
			'post_content'   => '',
			'post_status'    => 'inherit'
		);
		$attach_id = wp_insert_attachment( $attachment, $file, $post_id );
		require_once(ABSPATH . 'wp-admin/includes/image.php');
		$attach_data = wp_generate_attachment_metadata( $attach_id, $file );
		wp_update_attachment_metadata( $attach_id, $attach_data );
		set_post_thumbnail($post_id, $attach_id);
    }

	/**
	 * Gpt Sniper Seo Content
	 */
	public function gptsniper_seo_content(){
		$general_api = json_decode(get_option('gptsniper_general_api'),true);
		$openai_api_save = '';
		$user_key = '';
		if(!empty($general_api['api_key'])):
        	$openai_api_save = $general_api['api_key'];
			$user_key ='yes';
        else:
			$user_key ='no';
			$openai_api_save = get_option('gpt_open_rendom_api_keys');
        endif;
		$getMaxTokens = 1000;
		if(!empty($general_api['max_tokens'])):
			$getMaxTokens = $general_api['max_tokens'];
		endif; 
		$getTemperature =0.5;
		if(!empty($general_api['temperature'])):
			$getTemperature = $general_api['temperature'];
		endif;
		$model_option = 'text-davinci-003';
		if(!empty($general_api['model_option'])):
			$model_option = $general_api['model_option'];
		endif;
		$presence_penalty = 0.01;
		if(!empty($general_api['presence_penalty'])): 
			$presence_penalty = $general_api['presence_penalty'];
	    endif;
		$frequency_penalty = 0.01;
		if(!empty($general_api['frequency_penalty'])): 
			$frequency_penalty = $general_api['frequency_penalty'];
	    endif;
		$best_of = 1;
		if(!empty($general_api['best_of'])): 
			$best_of = $general_api['best_of'];
	    endif;
		$top_p = 0.01;
		if(!empty($general_api['top_p'])): 
			$top_p = $general_api['top_p'];
	    endif;
		$keyword = '';
		if(!empty($_POST['keywords'])):
		   $keyword = sanitize_text_field($_POST['keywords']);
		endif;
		$prompt = esc_html__("If you input a keyword, I will create a meta title and description for an attractive search result on Google in the United Kingdom for 2021. \n\nKeyword: Cheesecake recipes\nPage title: 65 Best Easy Cheesecake Recipes - How To Make Homemade Cheesecake\nMeta description: Making cheesecake is easier than you think! Whip up one of these easy, homemade cheesecake recipes to impress your friends.\n\nKeyword: VPN\nPage title: The Best VPN Services for 2021\nMeta description: A VPN, or virtual private network, is an easy way to improve your online privacy. We've reviewed scores of them, and these are the best VPN services we've tested.\n\nKeyword: Leather sofas\nPage title: Leather Sofas: Leather Sofas, Settees & Suites\nMeta description: Our leather sofas offer durability & unmatched comfort in a range of sizes & styles.\n\nKeyword: CRM\nPage title: What is Customer Relationship Management (CRM) Software?\nMeta description: Learn how to create order with a customer relationship management (CRM) system and keep everything you need to know about your customers in one place.\n\nKeyword: How to lose weight fast\nPage title: How to Lose Weight Fast in 3 Simple Steps\nMeta description: This simple 3-step plan can help you lose weight fast. Read about the 3-step plan, along with other science-backed weight loss tips, here.\n\nKeyword: things to do in london\nPage title: Over 165 Incredible Things To Do In London\nMeta description: From pop-up bars and beautiful experiences to escape rooms, crazy golf courses and more. Check out our guide to all of the amazing things to do in London, whatever the weather, month or day of the week.\n\n",'gpt-sniper'); 
        /**
		 * Content Code
		 */
		$header = array(
			'Authorization: Bearer '.$openai_api_save,
			'Content-type: application/json; charset=utf-8',
		  );
		$params = json_encode(array( 
		    'prompt' => "$prompt Keyword:$keyword",
		    'model'	 => $model_option,
		    'temperature' => (float)$getTemperature,
		    'max_tokens' => (float)$getMaxTokens,
			'stop'=>'["Keyword:"]'
		));   
		$curl = curl_init('https://api.openai.com/v1/completions');
		$options = array( 
			CURLOPT_POST => true,
			CURLOPT_HTTPHEADER =>$header,
			CURLOPT_POSTFIELDS => $params,
			CURLOPT_RETURNTRANSFER => true,
		);
		curl_setopt_array($curl, $options);
		$response = curl_exec($curl);
		$httpcode = curl_getinfo($curl, CURLINFO_RESPONSE_CODE);
		if(200 == $httpcode){ 
            $json_array = json_decode($response, true);
		    $choices = $json_array['choices'];
		    $postContent = $choices[0]["text"];
			$result_data = array(
				            'status'=>$httpcode,
							'content_data'=> $postContent,
							'message' => esc_html__('Successfully',"gpt-sniper")
							);
						
        }else{
			$result_data = array(
                'status'=>$httpcode,
    			'user_key'=>$user_key,
    			'message' => esc_html__("Something went to wrong!","gpt-sniper")
		    );
					    
		}
		echo json_encode($result_data);
	wp_die();	
	}
    /**
	 * Gpt Sniper Seo Content Save
	 */
	public function gptsniper_seo_content_save(){
		$page_title = '';
		if(!empty($_POST['page_title'])):
			$page_title = sanitize_text_field($_POST['page_title']); 
		endif;
	    $meta_description = '';
	    if(!empty($_POST['meta_description'])):
		 $meta_description = sanitize_text_field($_POST['meta_description']); 
	    endif;
		$includ_text_check = '';
	    if(!empty($_POST['includ_text_check'])):
		 $includ_text_check = sanitize_text_field($_POST['includ_text_check']); 
	    endif;
		
        $seo_data = json_encode(array(
		              'page_title'=>$page_title,
	                  'meta_description' => $meta_description,
					  'includ_text_check' => $includ_text_check 
	                ));
		if(update_option('gpt_seo_data', $seo_data)){
			$result_data = array(
				'status'=>200,
				'content_data'=> $postContent,
				'message' => esc_html__('Successfully',"gpt-sniper")
			   ); 

	    }else{ 
			$result_data = array(
				'status'=>400,
				'message' => esc_html__("Something went to wrong!","gpt-sniper")
				);
	    }
		echo json_encode($result_data);
	wp_die();
	}

	/**
	 * Gpt Sniper Head In Add Page Title and Meta Description
	 */
	public function gptsniper_seo_content_added_head(){
		$gpt_seo_data = json_decode(get_option('gpt_seo_data'),true);
		if(!empty($gpt_seo_data['page_title']) && !empty($gpt_seo_data['meta_description'])):
          echo '<meta name="'.esc_attr($gpt_seo_data['page_title']).'" content="'.wp_kses($gpt_seo_data['meta_description'],true).'">';
		endif;
	}

	/**
	 * Gpt Sniper Q&A 
	 */
	public function gptsniper_quetion_anwsers(){
		$general_api = json_decode(get_option('gptsniper_general_api'),true);
        $user_key = '';
		if(!empty($general_api['api_key'])):
			$openai_api_save = $general_api['api_key'];
			$user_key ='yes';
		else:
			$user_key ='no';
			$openai_api_save = get_option('gpt_open_rendom_api_keys');
		endif;

		$getMaxTokens = 1000;
		if(!empty($general_api['max_tokens'])):
			$getMaxTokens = $general_api['max_tokens'];
		endif; 
		$getTemperature =0.5;
		if(!empty($general_api['temperature'])):
			$getTemperature = $general_api['temperature'];
		endif;
		$model_option = 'text-davinci-003';
		if(!empty($general_api['model_option'])):
			$model_option = $general_api['model_option'];
		endif;
		$presence_penalty = 0.01;
		if(!empty($general_api['presence_penalty'])): 
			$presence_penalty = $general_api['presence_penalty'];
		endif;
		$frequency_penalty = 0.01;
		if(!empty($general_api['frequency_penalty'])): 
			$frequency_penalty = $general_api['frequency_penalty'];
		endif;
		$best_of = 1;
		if(!empty($general_api['best_of'])): 
			$best_of = $general_api['best_of'];
		endif;
		$top_p = 0.01;
		if(!empty($general_api['top_p'])): 
		   $top_p = $general_api['top_p'];
		endif;
		$quetion = '';
		if(!empty($_POST['quetion_description'])):
			$quetion = sanitize_text_field($_POST['quetion_description']);
		endif;
		/**
		 * Content Code
		 */
		$header = array(
			'Authorization: Bearer '.$openai_api_save,
			'Content-type: application/json',
			);
		$params = json_encode(array( 
			"model"=>"text-davinci-003",
			"prompt"=>"$quetion",
			"temperature"=> (float)$getTemperature,
			"max_tokens"=>(float)$getMaxTokens,
			"top_p"=> (float)$top_p,
			"best_of"=>(float)$best_of, 
			"frequency_penalty"=>(float)$frequency_penalty,
			"presence_penalty"=>(float)$presence_penalty,
			//"stop"=> ["n"]
		));      
		$curl = curl_init('https://api.openai.com/v1/completions');
		$options = array( 
			CURLOPT_POST => true,
			CURLOPT_HTTPHEADER =>$header,
			CURLOPT_POSTFIELDS => $params,
			CURLOPT_RETURNTRANSFER => true,
		  );
		curl_setopt_array($curl, $options);
		$response = curl_exec($curl);
		$httpcode = curl_getinfo($curl, CURLINFO_RESPONSE_CODE);
		if(200 == $httpcode){
			$json_array = json_decode($response, true);
			$choices = $json_array['choices'];
			$postContent = $choices[0]['text'];
            $result_data = array(
							'status'=>$httpcode,
							'content_data'=> trim($postContent),
							'message' => esc_html__('Successfully',"gpt-sniper")
							);
		}else{
            $result_data = array(
							'status'=>$httpcode,
							'user_key'=>$user_key,
							'message' => esc_html__("Something went to wrong!","gpt-sniper")
							);
			
		}
  	    echo json_encode($result_data);
        
    wp_die();
	} 

	/**
	 * Gpt Sniper Chatbot Option Ajax
	 */
    public function gptsniper_chatbot_option_ajax(){
        $general_api = json_decode(get_option('gptsniper_general_api'),true);
        $openai_api_save = '';
		$user_key = '';
		if(!empty($general_api['api_key'])):
			$openai_api_save = $general_api['api_key'];
			$user_key ='yes';
		else:
			$user_key ='no';
			$openai_api_save = get_option('gpt_open_rendom_api_keys');
		endif;
		
        $getMaxTokens = 1000;
		if(!empty($general_api['max_tokens'])):
			$getMaxTokens = $general_api['max_tokens'];
		endif; 
		$getTemperature =0.5;
		if(!empty($general_api['temperature'])):
			$getTemperature = $general_api['temperature'];
		endif;
		$model_option = 'text-davinci-003';
		if(!empty($general_api['model_option'])):
			$model_option = $general_api['model_option'];
		endif;
		$presence_penalty = 0.01;
		if(!empty($general_api['presence_penalty'])): 
			$presence_penalty = $general_api['presence_penalty'];
		endif;
		$frequency_penalty = 0.01;
		if(!empty($general_api['frequency_penalty'])): 
			$frequency_penalty = $general_api['frequency_penalty'];
		endif;
		$best_of = 1;
		if(!empty($general_api['best_of'])): 
			$best_of = $general_api['best_of'];
		endif;
		$top_p = 0.01;
		if(!empty($general_api['top_p'])): 
			$top_p = $general_api['top_p'];
		endif;
		
		$chat_get_value = '';
		if(!empty($_POST['chat_get_value'])):
			$chat_get_value = sanitize_text_field($_POST['chat_get_value']);
		endif;
	    $header = array(
		   'Authorization: Bearer '.$openai_api_save,
		   'Content-type: application/json; charset=utf-8',
		 );
		$params = json_encode(array(
		   'prompt' => $chat_get_value,
		   'model'	 => 'text-davinci-003',
		   'temperature' => (float)$getTemperature,
		   'max_tokens' => (float)$getMaxTokens,
		));
		$curl = curl_init('https://api.openai.com/v1/completions');
		$options = array(
			CURLOPT_POST => true,
			CURLOPT_HTTPHEADER =>$header,
			CURLOPT_POSTFIELDS => $params,
			CURLOPT_RETURNTRANSFER => true,
		);
		curl_setopt_array($curl, $options);
		$response = curl_exec($curl);
		$httpcode = curl_getinfo($curl, CURLINFO_RESPONSE_CODE);
		if(200 == $httpcode){
			$json_array = json_decode($response, true);
			$choices = $json_array['choices'];
			$postContent = $choices[0]["text"];
			$result_data = array(
				'status'=>$httpcode,
				'content_data'=> trim($postContent),
				'message' => esc_html__('Successfully',"gpt-sniper")
				);
		}else{
			$result_data = array(
			  'status'=>$httpcode,
			  'user_key'=>$user_key,
			  'message' => esc_html__("Something went to wrong!","gpt-sniper")
			);
		}
		echo json_encode($result_data);
	wp_die();	 
	}

	/**
	 * Gpt Sniper Chatbot Custom Setting 
	 */
	public function gptsniper_chatbot_custom_setting(){
        $chatbot_position = '';
	    if(!empty($_POST['chatbot_position'])):
		  $chatbot_position = sanitize_text_field($_POST['chatbot_position']); 
	    endif;
		$chatbot_font_size = '';
	    if(!empty($_POST['chatbot_font_size'])):
		  $chatbot_font_size = sanitize_text_field($_POST['chatbot_font_size']); 
	    endif;
		$font_color = '';
	    if(!empty($_POST['font_color'])):
		  $font_color = sanitize_text_field($_POST['font_color']); 
	    endif;
		$bg_color = '';
	    if(!empty($_POST['bg_color'])):
		   $bg_color = sanitize_text_field($_POST['bg_color']); 
	    endif;
		$chatbot_title_font_color = '';
	    if(!empty($_POST['chatbot_title_font_color'])):
		   $chatbot_title_font_color = sanitize_text_field($_POST['chatbot_title_font_color']); 
	    endif;
		$chatbot_title_bg_color = '';
	    if(!empty($_POST['chatbot_title_bg_color'])):
		   $chatbot_title_bg_color = sanitize_text_field($_POST['chatbot_title_bg_color']); 
	    endif;
		$label_font_color = '';
		if(!empty($_POST['label_font_color'])):
			$label_font_color = sanitize_text_field($_POST['label_font_color']); 
		 endif;
        $chatbost_setting_data = json_encode(array(
		              'chatbot_position'=> $chatbot_position,
	                  'chatbot_font_size' => $chatbot_font_size,
					  'chatbot_font_color' => $font_color,
					  'chatbot_bg_color' => $bg_color,
					  'label_font_color' => $label_font_color,
					  'chatbot_title_bg_color'=>$chatbot_title_bg_color,
					  'chatbot_title_font_color'=>$chatbot_title_font_color

	                ));
		if(update_option('gpt_chatbot_custom_setting', $chatbost_setting_data)){
			$result_data = array(
				'status'=>true,
				'content_data'=> $postContent,
				'message' => esc_html__('Save Successfully',"gpt-sniper")
			   ); 

	    }else{ 
			$result_data = array(
				'status'=>false,
				'message' => esc_html__("Something went to wrong!","gpt-sniper")
				);
	    }
		echo json_encode($result_data);
	wp_die();	
	}

	/**
	 * Gpt Sniper Q&A
	 */
	public function gptsniper_qa_custom_setting(){
        $qa_font_size = '';
	    if(!empty($_POST['qa_font_size'])):
		  $qa_font_size = sanitize_text_field($_POST['qa_font_size']); 
	    endif;
		$font_color = '';
	    if(!empty($_POST['font_color'])):
		  $font_color = sanitize_text_field($_POST['font_color']); 
	    endif;
		$bg_color = '';
	    if(!empty($_POST['bg_color'])):
		   $bg_color = sanitize_text_field($_POST['bg_color']); 
	    endif;
		$label_font_color = '';
		if(!empty($_POST['label_font_color'])):
			$label_font_color = sanitize_text_field($_POST['label_font_color']); 
		 endif;
        $qa_setting_data = json_encode(array(
		            'qa_font_size' => $qa_font_size,
					'qa_font_color' => $font_color,
					'qa_bg_color' => $bg_color,
					'label_font_color' => $label_font_color
                    )); 
		if(update_option('gpt_qa_custom_setting', $qa_setting_data)){
			$result_data = array(
				'status'=>true,
				'content_data'=> $postContent,
				'message' => esc_html__('Save Successfully',"gpt-sniper")
			   ); 

	    }else{ 
			$result_data = array(
				'status'=>false,
				'message' => esc_html__("Something went to wrong!","gpt-sniper")
				);
	    }
		echo json_encode($result_data);
	wp_die();	
	}

	/**
	 * GPT Sniper Add Schedule
	 */
	public function gptsniper_add_schedule_post(){
        global $wpdb;
		$scheduler_name = '';
	    if(!empty($_POST['gpt_scheduler_name'])):
		  $scheduler_name = sanitize_text_field($_POST['gpt_scheduler_name']); 
	    endif;
		$scheduler_keywords = '';
	    if(!empty($_POST['scheduler_keywords'])):
		  $scheduler_keywords = sanitize_text_field($_POST['scheduler_keywords']); 
	    endif;
		$post_crontime = '';
	    if(!empty($_POST['post_crontime'])):
		  $post_crontime = sanitize_text_field($_POST['post_crontime']); 
	    endif;
		$gpt_post_status = '';
	    if(!empty($_POST['gpt_post_status'])):
		  $gpt_post_status = sanitize_text_field($_POST['gpt_post_status']); 
	    endif;
		$add_featured_image = '';
	    if(!empty($_POST['add_featured_image'])):
		  $add_featured_image = sanitize_text_field($_POST['add_featured_image']); 
	    endif;
		$gpt_add_image = '';
	    if(!empty($_POST['gpt_add_image'])):
		  $gpt_add_image = sanitize_text_field($_POST['gpt_add_image']); 
	    endif;
		$gpt_openai_image_size = '';
	    if(!empty($_POST['gpt_openai_image_size'])):
		  $gpt_openai_image_size = sanitize_text_field($_POST['gpt_openai_image_size']); 
	    endif;
        $table_name = $wpdb->prefix .'schedule_poster';
		$data_result = $wpdb->insert($table_name, array(
            "sp_schedule_name" => $scheduler_name,
            "sp_keywords" => $scheduler_keywords,
            "sp_time_duration" => $post_crontime,
            "sp_date_time" => date('Y-m-d H:i:s'),
            "sp_post_status" => $gpt_post_status,
            "add_featured_image" => $add_featured_image,
            "add_image" => $gpt_add_image,
            "gpt_image_size" => $gpt_openai_image_size, 
            "create_date_time" => date('Y-m-d H:i:s'),
            "update_date_time" => date('Y-m-d H:i:s'),
            ),array('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')); 
		if($data_result > 0){
			$result_data = array(
				'status'=>true,
				'message' => esc_html__('Save Successfully',"gpt-sniper")
				); 
        }else{ 
			$result_data = array(
				'status'=>false,
				'message' => esc_html__("Something went to wrong!","gpt-sniper")
				);
		}
		echo json_encode($result_data);		 
    wp_die();
	}
	/**
	 * GPT Sniper Schedule
	 */
	public function gptsniper_delete_Schedule(){
		global $wpdb;
		$table_row_id = '';
	    if(!empty($_POST['row_id'])):
		  $table_row_id = sanitize_text_field($_POST['row_id']); 
	    endif;
        $table_name = $wpdb->prefix .'schedule_poster';
        $data_result = $wpdb->delete($table_name, array('sp_id' => $table_row_id),array('%d'));
		if($data_result > 0){
			$result_data = array(
				'status'=>true,
				'message' => esc_html__('Save Successfully',"gpt-sniper")
				); 
        }else{ 
			$result_data = array(
				'status'=>false,
				'message' => esc_html__("Something went to wrong!","gpt-sniper")
				);
		}
		echo json_encode($result_data);		
	    wp_die();	
	}
	
	/**
	 * GPT Sniper Create Heading List
	 */ 
	public function gptsniper_create_heading_lists($formatted_prompt=false){
	    
	    $general_api = json_decode(get_option('gptsniper_general_api'),true);
        $openai_api_save = '';
		$user_key = '';
		if(!empty($general_api['api_key'])):
			$openai_api_save = $general_api['api_key'];
			$user_key ='yes';
		else:
			$user_key ='no';
			$openai_api_save = get_option('gpt_open_rendom_api_keys');
		endif;
	    $method = esc_html__('POST','gpt-sniper');
	    $timeout = 45;
	    $url  = esc_url('https://api.openai.com/v1/completions');
	    $body = array(
            	'model' => 'text-davinci-003',
            	'prompt' => $formatted_prompt,
            	'temperature' => 0.7,
            	'max_tokens' => (int) 400,
            	'top_p' => 1,
            	'frequency_penalty' => 0.0,
            	'presence_penalty' => 0.0,
               );
        $args = array(
                'headers' => array(
                    'Content-Type'  => 'application/json',
                    'Authorization' => 'Bearer ' . $openai_api_save,
                   ),
                'method'  => $method,
                'timeout' => $timeout,
        		);
        if (!empty($body)) {
        	$args['body'] = wp_json_encode( $body );
        }	
        $response = wp_remote_post($url, $args); 
        $json = wp_remote_retrieve_body( $response );
        $headings_text ='';
        $details  = json_decode($json,true);
        $response = array(
            'status'  => $response['response']['code'],
            'message' => $response['response']['message'],
            'code'    => $response['response']['code'],
            'body'    => json_decode( $response['body'] ),
        );
        $headings = array();
        if (is_wp_error($response)) {
            return $headings;
        }
        $content = '';
        $message = '';
        $headinglist = '';
        if (isset($response['status']) && 200 === $response['status']) {
            $choices = isset($response['body']->choices ) ? $response['body']->choices : array();
            if (!empty($choices)) {
                foreach($choices as $choice) {
                  $content = $choice->text;
                }
            } else {
                $message .= esc_html__( 'Not enough choices generated.', 'gpt-sniper' );
            }
            if (is_string($content)) {
                $content = preg_replace('/[0-9]+\./', '', $content);
        	    $headinglist  = explode( '<momoseperator>', $content );
            } 
        	return array(
        			'message' => $response['message'],
        			'status'  => $response['status'],
        			'content' => $headinglist,
        		   );
        }else{
           return array(
        			'message' => $message,
        			'status'  => $response['status'],
        			'content' => $headinglist,
        		   ); 
        }
	    
	}
	/**
	 * GPT Sniper Create Large Content  
	 */ 
	 public function gptsniper_create_large_content($headings=false,$language=false){
	        $general_api = json_decode(get_option('gptsniper_general_api'),true);
            $openai_api_save = '';
    		$user_key = '';
    		if(!empty($general_api['api_key'])):
    			$openai_api_save = $general_api['api_key'];
    			$user_key ='yes';
    		else:
    			$user_key ='no';
    			$openai_api_save = get_option('gpt_open_rendom_api_keys');
    		endif;
    	    $method = esc_html__('POST','gpt-sniper');
    	    $timeout = 45;
	        $message = $content = '';
	        //$language = esc_html__('english','gpt-sniper');
            $prompt_text_article = esc_html__('article about','gpt-sniper');
	        $url = esc_url('https://api.openai.com/v1/completions');
	        $getMaxTokens = 1000;
    		if(!empty($general_api['max_tokens'])):
    			$getMaxTokens = $general_api['max_tokens'];
    		endif; 
    		$getTemperature =0.7;
    		if(!empty($general_api['temperature'])):
    			$getTemperature = $general_api['temperature'];
    		endif;
    		$model_option = 'text-davinci-003';
    		if(!empty($general_api['model_option'])):
    			$model_option = $general_api['model_option'];
    		endif;
    		$presence_penalty = 0.01;
    		if(!empty($general_api['presence_penalty'])): 
    			$presence_penalty = $general_api['presence_penalty'];
    		endif;
    		$frequency_penalty = 0.01;
    		if(!empty($general_api['frequency_penalty'])): 
    			$frequency_penalty = $general_api['frequency_penalty'];
    		endif;
    		$best_of = 1;
    		if(!empty($general_api['best_of'])): 
    			$best_of = $general_api['best_of'];
    		endif;
    		$top_p = 1;
    		if(!empty($general_api['top_p'])): 
    			$top_p = $general_api['top_p'];
    		endif;
	        if($headings):
              foreach ($headings as $index => $heading ) {
                $formatted_prompt  = 'One long paragraph on ' . $prompt_text_article . ' ' . $heading . ' without introduction and conclusion in ' . $language . ' language';
                $body = array(
                    'model' => $model_option,
                    'prompt' => $formatted_prompt,
                    'temperature' =>(float)$getTemperature,
                    'max_tokens' => (int)$getMaxTokens,
                    'top_p' => (float)$top_p,
                    'frequency_penalty' => (float)$frequency_penalty,
                    'presence_penalty' => (float)$presence_penalty,
                   );
                $args = array(
                        'headers' => array(
                            'Content-Type'  => 'application/json',
                            'Authorization' => 'Bearer ' . $openai_api_save,
                        ),
                        'method'  => $method,
                        'timeout' => $timeout,
                        );
                if (!empty($body)) {
                    $args['body'] = wp_json_encode( $body );
                }	
                $response = wp_remote_post($url, $args); 
                $json = wp_remote_retrieve_body( $response );
                $details  = json_decode($json,true);
                $response = array(
                    'status'  => $response['response']['code'],
                    'message' => $response['response']['message'],
                    'code'    => $response['response']['code'],
                    'body'    => json_decode( $response['body'] ),
                   );
                if(is_wp_error($response)) {
                    $message = esc_html__( 'Something went wrong with provided output from server.', 'gpt-sniper');
                }
                if(isset( $response['status'] ) && 200 === $response['status'] ) {
                    $message .= isset( $response['body']->error->message ) ? $response['body']->error->message : esc_html__( 'Provided url not found.', 'gpt-sniper');
                }
                if (isset($response['status'] ) && 200 === $response['status'] ) {
                    $choices = isset( $response['body']->choices ) ? $response['body']->choices : array();
                    if (!empty($choices)) {
                        foreach ( $choices as $choice ) {
                          $content .= $choice->text;
                        }
                    } else {
                         $message .= esc_html__( 'Not enough choices generated.', 'gpt-sniper');
                    }
                }
            }
            endif;
            return array(
        		 	'message' => $message,
        		 	'status'  => $response['status'],
        			'content' => $content,
        		    ); 
	     
	}
} 