<?php
$astrologer_options = get_option('astrologer_options');   
if(!empty($astrologer_options)){
    //print_r($astrologer_options);
    if(!empty($astrologer_options['vedicastro_switch']) && $astrologer_options['vedicastro_switch'] == '1'){
        if(!empty($astrologer_options['vedicastro_api'])){
            define("VEDICASTRO_API", $astrologer_options['vedicastro_api']);
        }
        if(!empty($astrologer_options['vedicastro_latitude'])){
            define("VEDICASTRO_LATITUDE", $astrologer_options['vedicastro_latitude']);
        }
        if(!empty($astrologer_options['vedicastro_longitude'])){
            define("VEDICASTRO_LONGITUDE", $astrologer_options['vedicastro_longitude']);
        }
        if(!empty($astrologer_options['vedicastro_location_tz'])){
            define("VEDICASTRO_LOCATION_TZ", $astrologer_options['vedicastro_location_tz']);
        }
    }
}
//daily panchang
function vedicastro_panchang(){
	if(defined('VEDICASTRO_API') && defined('VEDICASTRO_LATITUDE') && defined('VEDICASTRO_LONGITUDE') && defined('VEDICASTRO_LOCATION_TZ')){
		
		$currentdate = date("j");
		$month = date("m");
		$year = date("Y");
		$key = 'vedic_horoscope_panchang';
		$store_panchang = get_option($key);
		$arr_panchang = '';
		if(!empty($store_panchang)){
			$arr_panchang = json_decode($store_panchang,true);
		}
		if(!empty($arr_panchang)){
			if($arr_panchang['date'] == $currentdate){
				$panchange = json_decode($arr_panchang['panchang']);
				$panchange = $panchange->response;
				$day = $panchange->day;
				$day = $day->name;
				$tithi = $panchange->tithi;
				$tithi = $tithi->name;
				$tithi = $panchange->tithi;
				$vaar = $tithi->name;
				$nakshatra = $panchange->nakshatra;
				$karana = $panchange->karana;
				$yoga = $panchange->yoga;
				$advanced_details = $panchange->advanced_details;
				$date = $panchange->date;
				
				?>
				<div class="pk-panchang-wrapper">
					<h2 class="pk-panchang-text-center"><?= esc_html__("Today's Panchang","astrologer"); ?></h2>
					<div class="pk-panchang-panchang-details">
						<span class="pk-panchang-block"><b><?= esc_html__('Vaara','astrologer'); ?></b> : <?= esc_html($day); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Tithi','astrologer'); ?></b> : <?= esc_html($vaar); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($tithi->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($tithi->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($tithi->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Nakshatra','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Name','astrologer'); ?></b> : <?= esc_html($nakshatra->name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($nakshatra->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($nakshatra->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Next Nakshatra','astrologer'); ?></b> : <?= esc_html($nakshatra->next_nakshatra); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($nakshatra->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Karana','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Name','astrologer'); ?></b> : <?= esc_html($karana->name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($karana->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($karana->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($karana->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Yoga','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Name','astrologer'); ?></b> : <?= esc_html($yoga->name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($yoga->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($yoga->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($yoga->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Advanced Details','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Sun Rise','astrologer'); ?></b> : <?= esc_html($advanced_details->sun_rise); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Sun Set','astrologer'); ?></b> : <?= esc_html($advanced_details->sun_set); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Moon Rise','astrologer'); ?></b> : <?= esc_html($advanced_details->moon_rise); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Moon Set','astrologer'); ?></b> : <?= esc_html($advanced_details->moon_set); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Ayana','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->ayana); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Purnimanta Name','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->purnimanta_name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Purnimanta Start','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->purnimanta_start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Purnimanta End','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->purnimanta_end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Paksha','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->paksha); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Ritu','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->ritu); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Year','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Vikram Samvaat','astrologer'); ?></b> : <?= esc_html($advanced_details->years->vikram_samvaat); ?> - <?= esc_html($advanced_details->years->vikram_samvaat_name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Kali','astrologer'); ?></b> : <?= esc_html($advanced_details->years->kali); ?> - <?= esc_html($advanced_details->years->kali_samvaat_name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Saka','astrologer'); ?></b> : <?= esc_html($advanced_details->years->saka); ?> - <?= esc_html($advanced_details->years->saka_samvaat_name); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Vaara','astrologer'); ?></b> : <?= esc_html($advanced_details->vaara); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Date','astrologer'); ?></b> : <?= esc_html($date); ?></span>
						</hr>
						
					</div>
				</div>
				<?php
			}
			else{
				
				$curl = curl_init();
				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://api.vedicastroapi.com/v3-json/panchang/panchang?api_key='.VEDICASTRO_API.'&date='.$currentdate.'%2F'.$month.'%2F'.$year.'&tz='.VEDICASTRO_LOCATION_TZ.'&lat='.VEDICASTRO_LATITUDE.'&lon='.VEDICASTRO_LONGITUDE.'&time=05%3A20&lang=en',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'GET',
				));

				$response = curl_exec($curl);
				
				//Html
				$panchange = json_decode($response);
				$panchange = $panchange->response;
				$day = $panchange->day;
				$day = $day->name;
				$tithi = $panchange->tithi;
				$tithi = $tithi->name;
				$tithi = $panchange->tithi;
				$vaar = $tithi->name;
				$nakshatra = $panchange->nakshatra;
				$karana = $panchange->karana;
				$yoga = $panchange->yoga;
				$advanced_details = $panchange->advanced_details;
				$date = $panchange->date;
				
				?>
				<div class="pk-panchang-wrapper">
					<h2 class="pk-panchang-text-center">Today's Panchang</h2>
					<div class="pk-panchang-panchang-details">
						<span class="pk-panchang-block"><b><?= esc_html__('Vaara','astrologer'); ?></b> : <?= esc_html($day); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Tithi','astrologer'); ?></b> : <?= esc_html($vaar); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($tithi->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($tithi->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($tithi->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Nakshatra','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Name','astrologer'); ?></b> : <?= esc_html($nakshatra->name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($nakshatra->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($nakshatra->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Next Nakshatra','astrologer'); ?></b> : <?= esc_html($nakshatra->next_nakshatra); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($nakshatra->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Karana','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Name','astrologer'); ?></b> : <?= esc_html($karana->name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($karana->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($karana->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($karana->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Yoga','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Name','astrologer'); ?></b> : <?= esc_html($yoga->name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($yoga->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($yoga->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($yoga->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Advanced Details','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Sun Rise','astrologer'); ?></b> : <?= esc_html($advanced_details->sun_rise); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Sun Set','astrologer'); ?></b> : <?= esc_html($advanced_details->sun_set); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Moon Rise','astrologer'); ?></b> : <?= esc_html($advanced_details->moon_rise); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Moon Set','astrologer'); ?></b> : <?= esc_html($advanced_details->moon_set); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Ayana','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->ayana); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Purnimanta Name','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->purnimanta_name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Purnimanta Start','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->purnimanta_start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Purnimanta End','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->purnimanta_end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Paksha','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->paksha); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Ritu','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->ritu); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Year','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Vikram Samvaat','astrologer'); ?></b> : <?= esc_html($advanced_details->years->vikram_samvaat); ?> - <?= esc_html($advanced_details->years->vikram_samvaat_name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Kali','astrologer'); ?></b> : <?= esc_html($advanced_details->years->kali); ?> - <?= esc_html($advanced_details->years->kali_samvaat_name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Saka','astrologer'); ?></b> : <?= esc_html($advanced_details->years->saka); ?> - <?= esc_html($advanced_details->years->saka_samvaat_name); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Vaara','astrologer'); ?></b> : <?= esc_html($advanced_details->vaara); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Date','astrologer'); ?></b> : <?= esc_html($date); ?></span>
						</hr>
					</div>
				</div>
				<?php

				curl_close($curl);
				$data = array(
					'date' => $currentdate,
					'panchang' => $response
				);
				update_option('vedic_horoscope_panchang', json_encode($data));
			}
		}else{
			$curl = curl_init();
			curl_setopt_array($curl, array(
			  CURLOPT_URL => 'https://api.vedicastroapi.com/v3-json/panchang/panchang?api_key='.VEDICASTRO_API.'&date='.$currentdate.'%2F'.$month.'%2F'.$year.'&tz='.VEDICASTRO_LOCATION_TZ.'&lat='.VEDICASTRO_LATITUDE.'&lon='.VEDICASTRO_LONGITUDE.'&time=05%3A20&lang=en',
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'GET',
			));

			$response = curl_exec($curl);

			//Html
			$panchange = json_decode($response);
			$panchange = $panchange->response;
			$day = $panchange->day;
			$day = $day->name;
			$tithi = $panchange->tithi;
			$tithi = $tithi->name;
			$tithi = $panchange->tithi;
			$vaar = $tithi->name;
			$nakshatra = $panchange->nakshatra;
			$karana = $panchange->karana;
			$yoga = $panchange->yoga;
			$advanced_details = $panchange->advanced_details;
			$date = $panchange->date;
			
			?>
			<div class="pk-panchang-wrapper">
				<h2 class="pk-panchang-text-center">Today's Panchang</h2>
				<div class="pk-panchang-panchang-details">
					<span class="pk-panchang-block"><b><?= esc_html__('Vaara','astrologer'); ?></b> : <?= esc_html($day); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Tithi','astrologer'); ?></b> : <?= esc_html($vaar); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($tithi->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($tithi->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($tithi->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Nakshatra','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Name','astrologer'); ?></b> : <?= esc_html($nakshatra->name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($nakshatra->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($nakshatra->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Next Nakshatra','astrologer'); ?></b> : <?= esc_html($nakshatra->next_nakshatra); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($nakshatra->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Karana','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Name','astrologer'); ?></b> : <?= esc_html($karana->name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($karana->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($karana->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($karana->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Yoga','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Name','astrologer'); ?></b> : <?= esc_html($yoga->name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Start','astrologer'); ?></b> : <?= esc_html($yoga->start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('End','astrologer'); ?></b> : <?= esc_html($yoga->end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Special','astrologer'); ?></b> : <?= esc_html($yoga->special); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Advanced Details','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Sun Rise','astrologer'); ?></b> : <?= esc_html($advanced_details->sun_rise); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Sun Set','astrologer'); ?></b> : <?= esc_html($advanced_details->sun_set); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Moon Rise','astrologer'); ?></b> : <?= esc_html($advanced_details->moon_rise); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Moon Set','astrologer'); ?></b> : <?= esc_html($advanced_details->moon_set); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Ayana','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->ayana); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Purnimanta Name','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->purnimanta_name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Purnimanta Start','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->purnimanta_start); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Purnimanta End','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->purnimanta_end); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Paksha','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->paksha); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Ritu','astrologer'); ?></b> : <?= esc_html($advanced_details->masa->ritu); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Year','astrologer'); ?></b></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Vikram Samvaat','astrologer'); ?></b> : <?= esc_html($advanced_details->years->vikram_samvaat); ?> - <?= esc_html($advanced_details->years->vikram_samvaat_name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Kali','astrologer'); ?></b> : <?= esc_html($advanced_details->years->kali); ?> - <?= esc_html($advanced_details->years->kali_samvaat_name); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Saka','astrologer'); ?></b> : <?= esc_html($advanced_details->years->saka); ?> - <?= esc_html($advanced_details->years->saka_samvaat_name); ?></span>
						<hr>
						<span class="pk-panchang-block"><b><?= esc_html__('Vaara','astrologer'); ?></b> : <?= esc_html($advanced_details->vaara); ?></span>
						<span class="pk-panchang-block"><b><?= esc_html__('Date','astrologer'); ?></b> : <?= esc_html($date); ?></span>
						</hr>
					
				</div>
			</div>
			<?php
			
			curl_close($curl);
			$data = array(
				'date' => $currentdate,
				'panchang' => $response
			);
			update_option('vedic_horoscope_panchang', json_encode($data));
		}
	}else{
		echo 'You missed somthing in vediastro api details.';
	}
}

//Vedicastro daily prediction
function vedicastro_daily_prediction( $sign ){
	if(defined('VEDICASTRO_API') && defined('VEDICASTRO_LATITUDE') && defined('VEDICASTRO_LONGITUDE') && defined('VEDICASTRO_LOCATION_TZ')){
		$cdate = date("j");
		$month = date("m");
		$year = date("Y");
		
		$key = 'horoscope_'.$sign;
		
		if($sign == "aries"){
			$zodiac = 1;
		}elseif($sign == "taurus"){
			$zodiac = 2;
		}elseif($sign == "gemeni"){
			$zodiac = 3;
		}elseif($sign == "cancer"){
			$zodiac = 4;
		}elseif($sign == "leo"){
			$zodiac = 5;
		}elseif($sign == "virgo"){
			$zodiac = 6;
		}elseif($sign == "libra"){
			$zodiac = 7;
		}elseif($sign == "scorpio"){
			$zodiac = 8;
		}elseif($sign == "sagittarius"){
			$zodiac = 9;
		}elseif($sign == "capricorn"){
			$zodiac = 10;
		}elseif($sign == "aquarius"){
			$zodiac = 11;
		}elseif($sign == "pisces"){
			$zodiac = 12;
		}
		
		$store_perdiction = get_option($key);
		$arr_prediction = '';
		if(!empty($store_perdiction)){
			$arr_prediction = json_decode($store_perdiction,true);
		}
		if(!empty($arr_prediction)){
			if($arr_prediction['date'] == $cdate){
				$data = json_decode($arr_prediction['prediction'], true);
				$prediction = $data['response'];
				$response = $prediction['bot_response'];
				$result = '';
				$result .= '<b>'.esc_html__('Lucky Color: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($prediction['lucky_color']).'</p><hr>';
				$result .= '<b>'.esc_html__('Lucky Number: ','astrologer').'</b><p>';
				foreach($prediction['lucky_number'] as $num){
					$result .= '<span>'.esc_html($num).',</span>';
				}
				$result .= '</p><hr>';
				$result .= '<b>'.esc_html__('Physique: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['physique']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Status: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['status']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Finances: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['finances']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Relationship: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['relationship']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Career: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['career']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Travel: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['travel']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Family: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['family']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Friends: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['friends']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Health: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['health']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Total Score: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['total_score']['split_response']).'</p>';
				
				echo $result;
				
			}else{
				//Daily Horoscope
				$curl = curl_init();
				curl_setopt_array($curl, array(
				  CURLOPT_URL => 'https://api.vedicastroapi.com/v3-json/prediction/daily-sun?zodiac='.$zodiac.'&date='.$cdate.'%2F'.$month.'%2F'.$year.'&show_same=true&api_key='.VEDICASTRO_API.'&lang=en&split=true&type=big',
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => '',
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 0,
				  CURLOPT_FOLLOWLOCATION => true,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => 'GET',
				));

				$response = curl_exec($curl);

				curl_close($curl);
				//Html
				$data = json_decode($response,true);
				$prediction = $data['response'];
				$response = $prediction['bot_response'];
				$result = '';
				$result .= '<b>Lucky Color: </b>';
				$result .= '<p>'.$prediction['lucky_color'].'</p><hr>';
				$result .= '<b>Lucky Number: </b><p>';
				foreach($prediction['lucky_number'] as $num){
					$result .= '<span>'.$num.',</span>';
				}
				$result .= '</p><hr>';
				$result .= '<b>'.esc_html__('Physique: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['physique']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Status: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['status']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Finances: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['finances']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Relationship: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['relationship']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Career: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['career']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Travel: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['travel']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Family: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['family']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Friends: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['friends']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Health: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['health']['split_response']).'</p><hr>';
				$result .= '<b>'.esc_html__('Total Score: ','astrologer').'</b>';
				$result .= '<p>'.esc_html($response['total_score']['split_response']).'</p>';
				echo $result;
				
				$data = array(
				   'date' => $cdate,
				   'prediction' => $response
				);
				update_option($key,json_encode($data));
			}
		}
		else{
			//Daily Horoscope
			$curl = curl_init();
			curl_setopt_array($curl, array(
			  CURLOPT_URL => 'https://api.vedicastroapi.com/v3-json/prediction/daily-sun?zodiac='.$zodiac.'&date='.$cdate.'%2F'.$month.'%2F'.$year.'&show_same=true&api_key='.VEDICASTRO_API.'&lang=en&split=true&type=big',
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'GET',
			));

			$response = curl_exec($curl);

			curl_close($curl);
			//Html
			$data = json_decode($response,true);
			$prediction = $data['response'];
			$response = $prediction['bot_response'];
			$result = '';
			$result .= '<b>Lucky Color: </b>';
			$result .= '<p>'.$prediction['lucky_color'].'</p><hr>';
			$result .= '<b>Lucky Number: </b><p>';
			foreach($prediction['lucky_number'] as $num){
				$result .= '<span>'.$num.',</span>';
			}
			$result .= '</p><hr>';
			$result .= '<b>'.esc_html__('Physique: ','astrologer').'</b>';
			$result .= '<p>'.esc_html($response['physique']['split_response']).'</p><hr>';
			$result .= '<b>'.esc_html__('Status: ','astrologer').'</b>';
			$result .= '<p>'.esc_html($response['status']['split_response']).'</p><hr>';
			$result .= '<b>'.esc_html__('Finances: ','astrologer').'</b>';
			$result .= '<p>'.$response['finances']['split_response'].'</p><hr>';
			$result .= '<b>Relationship: </b>';
			$result .= '<p>'.$response['relationship']['split_response'].'</p><hr>';
			$result .= '<b>Career: </b>';
			$result .= '<p>'.$response['career']['split_response'].'</p><hr>';
			$result .= '<b>Travel: </b>';
			$result .= '<p>'.$response['travel']['split_response'].'</p><hr>';
			$result .= '<b>Family: </b>';
			$result .= '<p>'.$response['family']['split_response'].'</p><hr>';
			$result .= '<b>Friends: </b>';
			$result .= '<p>'.$response['friends']['split_response'].'</p><hr>';
			$result .= '<b>Health: </b>';
			$result .= '<p>'.$response['health']['split_response'].'</p><hr>';
			$result .= '<b>Total Score: </b>';
			$result .= '<p>'.$response['total_score']['split_response'].'</p>';
			echo $result;
			
			$data = array(
			   'date' => $cdate,
			   'prediction' => $response
			);
			update_option($key,json_encode($data));
		}
	}else{
		echo 'You missed somthing in vediastro api details.';
	}
}