<?php 
/**
 * Heading shortcode js_composer
 */
add_shortcode('astrologercore_heading','astrologercore_heading');
function astrologercore_heading($atts, $content){
    
    extract(shortcode_atts(
		array(
		'heading' => '',
		'color_heading' => '',
		'sub_heading_color' => '',
		'heading_c_class' => '',
		'heading_alignment' => '',
		'description' => '',
		'heading_img' => '',
		'heading_style' => 'style1',
		 ),$atts 
	 ) );
	
	$result = $css='';
	
	$heading_color = '';
    if ( ! empty($color_heading) ) {
    	$heading_color = 'color:' . esc_attr($color_heading) . ';';
    }
    
    $sub_heading = '';
    if (!empty($sub_heading_color)) {
    	$sub_heading = 'color:' . esc_attr($sub_heading_color) . ';';
    }
    
	$heading_color_style   = ( $heading_color) ? 'style="' . esc_attr($heading_color) . '"' : '';
    $sub_heading_style   = ( $sub_heading) ? 'style="' . esc_attr($sub_heading) . '"' : '';
    
	if($heading_style =='style1'){
        	
        	$result .='<div class="al-heading-wrap '.esc_attr($heading_c_class).' '.esc_html($heading_alignment).'">';
        	if($heading_alignment == 'text-center'){
        			$heading_alignment ='text-center';
        	}
        	$result.='<h1 class="al-heading '.esc_attr($heading_alignment).'" '.$heading_color_style.'>';
        	if(!empty($heading)){
        	   $result.= esc_html($heading);
        	}
        	$result.='</h1>';
        	if(!empty($description)){			
                $result.='<div class="al-sub" '.$sub_heading_style.'>'. rawurldecode(base64_decode($description)) .'</div>';
        	} 
        	$result.='</div>';
        	
    }else{
	    
        $result .='<div class="al-heading-wrap al-heading-img'.esc_attr($heading_c_class).' '.esc_attr($heading_alignment).'">';
        if($heading_alignment == 'text-center'){
           $heading_alignment ='text-center';
        }
    	$result.='<h1 class="al-heading '.esc_attr($heading_alignment).'" '.$heading_color_style.'>';
    	if(!empty($heading)){
    	   $result.= esc_html($heading);
    	}
    	$result.='</h1>';
    	$imageSrc = wp_get_attachment_image_src($heading_img, 'full');
    	$result.='<img src="'. esc_url($imageSrc[0]).'" alt="'.esc_attr__('Heaing','astrologer').'" class="img-responsive">';
    	if(!empty($description)){			
            $result.='<div class="al-sub" '.$sub_heading_style.'>'. rawurldecode(base64_decode($description)) .'</div>';
    	} 
        $result.='</div>';
         
    } 
    return $result;   
}