<?php 
/**
 * Blog shortcode js_composer
 */
add_shortcode('astrologercore_blog','astrologercore_blog');
function astrologercore_blog($atts,$content){
    $icon_path = plugin_dir_url( dirname( __FILE__ ) ).'shortcodes/images';
    extract(shortcode_atts(
		array(
		'blog_number' => '',
		'blog_column' => '',
		'cat' => 'all',
		'blog_c_class' => '',
		 ),$atts 
	 ) );
	$result = '';
	$result .='<div class="'.esc_attr($blog_c_class).' row text-left">';
	if($cat != 'all'){
        $args['tax_query']	= array(
        array(
        	'taxonomy' => 'category',
        	'field'    => 'slug',
        	'terms'    => $cat,
           )
        );
	}
	elseif($cat = 'all'){
	    $cat='';
	}
    $blog_loop = new WP_Query( array(
        'post_type'=>'post',
        'posts_per_page' => $blog_number,
	    'category_name' => $cat,
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1
    ) );
    if($blog_loop->have_posts() ) :
        while ( $blog_loop->have_posts() ) : $blog_loop->the_post();
          	    $result .='<div class="'.esc_attr($blog_column).' col-sm-6">
				  <div class="al-blog-thumb-section">
					<a class="al-blog-img" href="'.esc_url(get_the_permalink()).'">
						<div class="al-blog-img-inner">
							'.get_the_post_thumbnail().'
						</div>
						<span class="al-blog-date">'.esc_html(get_the_date()).'</span>
					</a>
					<div class="al-blog-details">
						<div class="al-blog-data">
							<ul>
								<li>
									<span class="al-sm-icon">
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid" viewBox="0 0 15 16">
										<path d="M14.393,15.913 C14.264,15.970 14.131,15.997 13.999,15.997 C13.853,15.997 13.709,15.963 13.575,15.893 C13.293,15.747 13.089,15.469 13.000,15.108 C12.724,13.988 12.254,13.098 11.563,12.387 C10.005,10.783 8.158,10.249 6.076,10.801 C4.056,11.336 2.703,12.713 2.053,14.893 C1.787,15.786 1.331,16.140 0.698,15.945 C0.406,15.855 -0.237,15.517 0.091,14.319 C1.053,10.795 4.048,8.452 7.543,8.482 C11.088,8.515 14.063,10.930 14.946,14.492 C15.112,15.159 14.905,15.691 14.393,15.913 ZM7.497,7.509 C7.495,7.509 7.493,7.509 7.491,7.509 C6.526,7.508 5.619,7.115 4.937,6.405 C4.255,5.693 3.880,4.750 3.882,3.748 C3.884,2.748 4.263,1.806 4.949,1.095 C5.633,0.387 6.537,-0.003 7.496,-0.003 C7.499,-0.003 7.502,-0.003 7.505,-0.003 C9.494,0.003 11.111,1.692 11.109,3.761 C11.109,4.764 10.732,5.706 10.048,6.414 C9.366,7.121 8.460,7.509 7.497,7.509 ZM8.617,2.608 C8.325,2.302 7.935,2.132 7.519,2.131 C7.517,2.131 7.515,2.131 7.513,2.131 C6.614,2.131 5.933,2.833 5.928,3.767 C5.926,4.191 6.087,4.595 6.382,4.903 C6.681,5.216 7.077,5.388 7.497,5.389 C7.497,5.389 7.497,5.389 7.497,5.389 C8.360,5.389 9.066,4.661 9.070,3.766 C9.072,3.329 8.911,2.917 8.617,2.608 Z"/>
										</svg>
									</span>
									<a class="al-blog-authore" href="'.esc_url(get_the_permalink()).'">
										'.esc_html__('By - ','astrologer').''.get_the_author().'
									</a>
								</li>
								<li>
									<span class="al-sm-icon">
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid" viewBox="0 0 20 16">
										<path d="M19.208,11.276 C18.679,12.068 17.953,12.736 17.032,13.282 C17.106,13.464 17.182,13.630 17.260,13.781 C17.339,13.934 17.432,14.079 17.539,14.220 C17.647,14.360 17.731,14.470 17.790,14.549 C17.850,14.629 17.947,14.740 18.080,14.884 C18.214,15.028 18.300,15.122 18.337,15.168 C18.345,15.176 18.359,15.193 18.382,15.219 C18.404,15.245 18.421,15.265 18.432,15.276 C18.443,15.287 18.458,15.307 18.476,15.333 C18.495,15.359 18.508,15.380 18.516,15.395 L18.543,15.451 C18.543,15.451 18.551,15.474 18.566,15.520 C18.580,15.565 18.582,15.590 18.571,15.594 C18.560,15.597 18.557,15.622 18.560,15.667 C18.538,15.773 18.489,15.856 18.415,15.917 C18.341,15.978 18.258,16.004 18.169,15.997 C17.798,15.944 17.477,15.883 17.210,15.815 C16.064,15.512 15.030,15.027 14.107,14.360 C13.437,14.481 12.783,14.543 12.143,14.543 C10.126,14.543 8.370,14.043 6.875,13.043 C7.306,13.073 7.634,13.088 7.857,13.088 C9.055,13.088 10.205,12.918 11.305,12.577 C12.406,12.236 13.389,11.747 14.252,11.111 C15.182,10.413 15.897,9.611 16.395,8.703 C16.894,7.794 17.143,6.831 17.143,5.817 C17.143,5.233 17.057,4.658 16.886,4.089 C17.846,4.627 18.605,5.301 19.163,6.111 C19.721,6.922 20.000,7.794 20.000,8.725 C20.000,9.634 19.736,10.484 19.208,11.276 ZM11.802,10.856 C10.594,11.375 9.278,11.634 7.857,11.633 C7.217,11.633 6.562,11.573 5.893,11.452 C4.970,12.118 3.936,12.603 2.790,12.906 C2.522,12.974 2.203,13.035 1.831,13.088 L1.797,13.088 C1.715,13.088 1.639,13.058 1.568,12.997 C1.498,12.937 1.455,12.857 1.439,12.759 C1.432,12.736 1.429,12.711 1.429,12.685 C1.429,12.659 1.431,12.634 1.434,12.611 C1.438,12.588 1.445,12.565 1.456,12.543 L1.484,12.486 C1.484,12.486 1.498,12.466 1.524,12.424 C1.549,12.383 1.565,12.363 1.568,12.367 C1.572,12.371 1.589,12.352 1.619,12.311 C1.648,12.269 1.663,12.252 1.663,12.259 C1.700,12.214 1.786,12.119 1.920,11.975 C2.053,11.831 2.151,11.720 2.210,11.640 C2.270,11.561 2.353,11.451 2.461,11.310 C2.569,11.170 2.662,11.024 2.740,10.873 C2.818,10.722 2.894,10.555 2.969,10.373 C2.046,9.828 1.321,9.158 0.793,8.362 C0.264,7.567 0.000,6.718 0.000,5.817 C0.000,4.764 0.350,3.791 1.050,2.897 C1.749,2.004 2.703,1.297 3.912,0.778 C5.121,0.259 6.436,-0.001 7.857,-0.001 C9.279,-0.001 10.594,0.259 11.802,0.778 C13.012,1.297 13.966,2.003 14.665,2.897 C15.364,3.791 15.714,4.764 15.714,5.817 C15.714,6.870 15.364,7.844 14.665,8.737 C13.966,9.631 13.012,10.337 11.802,10.856 ZM13.410,3.647 C12.826,2.973 12.039,2.439 11.049,2.044 C10.059,1.651 8.996,1.454 7.857,1.454 C6.719,1.454 5.655,1.651 4.665,2.044 C3.676,2.439 2.889,2.973 2.305,3.647 C1.721,4.320 1.429,5.044 1.429,5.817 C1.429,6.438 1.626,7.036 2.020,7.612 C2.415,8.188 2.969,8.688 3.683,9.112 L4.766,9.748 L4.375,10.702 C4.628,10.551 4.859,10.403 5.067,10.259 L5.558,9.907 L6.150,10.021 C6.730,10.126 7.300,10.179 7.857,10.179 C8.996,10.179 10.059,9.983 11.049,9.589 C12.039,9.196 12.826,8.661 13.410,7.987 C13.994,7.313 14.286,6.590 14.286,5.817 C14.286,5.044 13.994,4.320 13.410,3.647 Z"></path>
										</svg>
									</span>
									<a href="'.esc_url(get_the_permalink()).'">
										'.esc_html(get_comments_number()).''.esc_html__('comments','astrologer').'
									</a>
								</li>
							</ul>
						</div>
						<a href="'.esc_url(get_the_permalink()).'">
							<h4 class="al-blog-title">'.esc_html(get_the_title()).'</h4>
						</a>
						<p>'.esc_html(get_the_excerpt()) .'</p>
					</div> 
				</div></div>';
		endwhile;
	endif;
	$result .=' </div>';
    $big = 999999999; // need an unlikely integer
    $pages = paginate_links( array(
        'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
        'format' => '?paged=%#%',
        'current' => max( 1, get_query_var('paged') ),
        'total' => $blog_loop->max_num_pages,
        'prev_text' => '&laquo;',
        'next_text' => '&raquo;',
        'type'  => 'array',
    ) );
    if( is_array( $pages ) ) {
    $paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
    $result .='<div class="pagination-wrap"><ul class="pagination">';
    foreach ( $pages as $page ) {
        $result .= "<li>$page</li>";
    }
    $result .='</ul></div>';
    }

wp_reset_postdata();
	return $result;   
} 
function astrologercore_blog_excerpt_length( $length ) {
    return 30;
}
add_filter( 'excerpt_length', 'astrologercore_blog_excerpt_length');