<?php
/************ Daily Prediction ************/	
function daily_nakshatra_prediction($sign){
    $theme_option = '';
    if(function_exists('astrologer_theme_option_settings')):
    	$theme_option = astrologer_theme_option_settings();
    endif;
    $daily_api_Key = '';
    if(!empty($theme_option['daily_api_Key'])):
    	$daily_api_Key = $theme_option['daily_api_Key'];
    endif;
    
    
	$curl = curl_init();
	curl_setopt_array($curl, [
		CURLOPT_URL => "https://sameer-kumar-aztro-v1.p.rapidapi.com/?sign=".$sign."&day=today",
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_ENCODING => "",
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 30,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => "POST",
		CURLOPT_HTTPHEADER => [
			"x-rapidapi-host: sameer-kumar-aztro-v1.p.rapidapi.com",
			"x-rapidapi-key: $daily_api_Key"
		],
	]);

	$response = curl_exec($curl);
	$err = curl_error($curl);

	curl_close($curl);

	if ($err) {
		return "cURL Error #:" . $err;
	} else {
		return $response;
	}
}


/***** Horoscope Today's panchang API function *****/
function horoscope_panchang(){
$theme_option = '';
if(function_exists('astrologer_theme_option_settings')):
	$theme_option = astrologer_theme_option_settings();
endif;
$daily_api = '';
if(!empty($theme_option['daily_api'])):
	$daily_api = $theme_option['daily_api'];
endif;
$user_Id = '';
if(!empty($theme_option['user_Id'])):
	$user_Id = $theme_option['user_Id'];
endif;
$api_Key = '';
if(!empty($theme_option['api_Key'])):
	$api_Key = $theme_option['api_Key'];
endif;

require_once 'src/AstrologyApiClient.php';
$userId = $user_Id;
$apiKey = $api_Key;

$data = array(

    'date' => date("d"),
    'month' => date("m"),
    'year' => date("Y"),
    'hour' => date("h"),
    'minute' => date('i'),
    'latitude' => 25.123,
    'longitude' => 82.34,
    'timezone' => 5.5,
);

// instantiate AstrologyApiClient class
$astrologyApi = new AstrologyApiClient($userId, $apiKey);

//Get Basic Panchang
$responseData = $astrologyApi->getBasicPanchang($data['date'], $data['month'], $data['year'], $data['hour'], $data['minute'], $data['latitude'], $data['longitude'], $data['timezone']);

// print response data. Change the name of variable to get the respective panchang response data
//echo $responseData;
$json = json_decode($responseData, true);
echo "\n";
$day = $json['day'];
$tithi = $json['tithi'];
$nakshatra = $json['nakshatra'];
$yog = $json['yog'];
$karan = $json['karan'];
$sunrise = $json['sunrise'];
$sunset = $json['sunset'];
$vedic_sunrise = $json['vedic_sunrise'];
$vedic_sunset = $json['vedic_sunset'];
$moon = plugin_dir_url( __DIR__ ).'public/shortcodes/images/zodics/moon.png';
$sun = plugin_dir_url( __DIR__ ).'public/shortcodes/images/zodics/sun.png';
if(!empty($api_Key)):
?>

<div class="container">
<div class="row">
    <div class="col-lg-6 col-md-6 col-sm-12">
        <div class="al-tab">
            <div class="al-inner-img">
                <span><img src="<?php echo esc_url($sun); ?>" alt=""></span>
                <span>Sunrise</span>
            </div>
            <div class="al-date">
               <?php echo esc_html($sunrise); ?>
            </div>
        </div>
    </div>
    <div class="col-lg-6 col-md-6 col-sm-12">
        <div class="al-tab">
            <div class="al-inner-img">
                <span><img src="<?php echo esc_url($moon); ?>" alt=""></span>
                <span>Sunset</span>
            </div>
            <div class="al-date">
                 <?php echo esc_html($sunset); ?>
            </div>
        </div>
    </div>
</div>
</div>
<div class="container">
<div class="astro-table">
		<div class="table-responsive">
			<table class="table table-bordered mb-0">
                <tbody>
                	<tr>
                		<td>Weekday</td>
                		<td><?php echo esc_html($day); ?></td>
                	</tr>
                	<tr>
                		<td>Tithi</td>
                		<td><?php echo esc_html($tithi); ?></td>
                	</tr>
                	<tr>
                		<td>Nakshatra</td>
                		<td><?php echo esc_html($nakshatra); ?></td>
                	</tr>
                	<tr>
                		<td>Yoga</td>
                		<td><?php echo esc_html($yog); ?></td>
                	</tr>
                	<tr>
                		<td>Karan</td>
                		<td><?php echo esc_html($karan); ?></td>
                	</tr>
                	<tr>
                		<td>Vedic Sunrise</td>
                		<td><?php echo esc_html($vedic_sunrise); ?></td>
                	</tr>
                	<tr>
                		<td>Vedic Sunset</td>
                		<td><?php echo esc_html($vedic_sunset); ?></td>
                	</tr>
                </tbody>
            </table>
		</div>
	</div>
	</div>
<?php
endif;
}
