<?php
/**
 * Astrologercore Widgets 
 * version 1.0.0
 * Register and load the widget
 */
  
function astrologer_load_widget() {    
    register_widget('astrologercore_widget_textlogo');
    register_widget('astrologer_widget_menu'); 
    register_widget('astrologer_widget_recentpost');
    register_widget('astrologer_widget_image');
	register_widget('astrologercore_widget_Contact');
	register_widget('astrologercore_top_header_contact_info');	
	register_widget('astrologercore_top_header_profile');	
	register_widget('astrologercore_top_header_mincart');
	register_widget('astrologercore_widget_app_download'); 
}
add_action('widgets_init', 'astrologer_load_widget'); 
  
/**
 * Text Summary and Logo Widget
 **/ 
class astrologercore_widget_textlogo extends WP_Widget {
    
    function  __construct() {
    	parent::__construct(
        'astrologercore_widget_textlogo', // Base ID of your widget
            esc_html__('Astrologer Text Summary & Logo', 'astrologer'),  // Widget name will appear in UI
            array( 'description' => esc_html__( 'Astrologer Text summary and logo', 'astrologer' ), ) // Widget description
            );
    }

    public function widget( $args, $instance ) {
        $icon_path = plugin_dir_url( dirname( __FILE__ ) ).'/widgets/images/';
        $main_site_logo = '';
        if ( isset( $instance[ 'main_site_logo' ] ) ) {
            $main_site_logo = $instance[ 'main_site_logo' ];
        }
        $widget_desc_data = '';
        if ( isset( $instance[ 'widget_desc_data' ] ) ) {
            $widget_desc_data = $instance[ 'widget_desc_data' ];
        }
        $social_title = '';
        if ( isset( $instance[ 'social_title' ] ) ) {
            $social_title = $instance[ 'social_title' ];
        }
        $facebook_url = '';
        if ( isset( $instance[ 'facebook_url' ] ) ) {
            $facebook_url = $instance[ 'facebook_url' ];
        }
        $twitter_url = '';
        if ( isset( $instance[ 'twitter_url' ] ) ) {
            $twitter_url = $instance[ 'twitter_url' ];
        }
         $googleplus_url = '';
        if ( isset( $instance[ 'googleplus_url' ] ) ) {
            $googleplus_url = $instance[ 'googleplus_url' ];
        }
         $youtube_url = '';
        if ( isset( $instance[ 'youtube_url' ] ) ) {
            $youtube_url = $instance[ 'youtube_url' ];
        }
        $instagram_url = '';
        if ( isset( $instance[ 'instagram_url' ] ) ) {
            $instagram_url = $instance[ 'instagram_url' ];
        }
        ?>
		<div class="al-footer-widget">
			<?php if(!empty($main_site_logo)): ?>
				<div class="al-footer-logo">
                    <a href="<?php echo esc_url(home_url('/')); ?>">
						<img src="<?php echo esc_url($main_site_logo); ?>" alt="<?php esc_attr_e('logo','astrologer'); ?>" />
					</a>
                </div>
			<?php else: ?>
				<div class="al-footer-logo">
                    <a href="<?php echo esc_url(home_url('/')); ?>">
                        <img src="<?php echo esc_url($icon_path.'footer-logo.svg'); ?>" alt="<?php esc_attr_e('logo','astrologer'); ?>" />
                    </a>
                </div>
			<?php endif; ?>
            <?php if(!empty($widget_desc_data)): ?>
                <div class="al-footer-text">
                    <p><?php echo esc_html($widget_desc_data); ?></p>
                </div>  
            <?php endif; ?>    
            <div class="al-share-box">  
				<?php if(!empty($social_title)): ?>
                    <p><?php echo esc_html($social_title); ?></p>
                <?php endif; ?>
				<ul class="al-social-icons">
                    <?php if(!empty($facebook_url)): ?>
                    <li>
                    <a href="<?php echo esc_url($facebook_url);?>" target = "<?php esc_attr_e('_blank','astrologer'); ?>">
                        <img src="<?php echo esc_url($icon_path.'facebook.svg'); ?>" alt="<?php echo esc_attr__('facebook','astrologer'); ?>">
                    </a>
                    </li>
                    <?php endif; 
                    if(!empty($twitter_url)): ?>
                    <li>
                    <a href="<?php echo esc_url($twitter_url);?>" target = "<?php esc_attr_e('_blank','astrologer'); ?>">
                        <img src="<?php echo esc_url($icon_path.'twitter.svg'); ?>" alt="<?php echo esc_attr__('twitter','astrologer'); ?>">
                    </a>
                    </li>
                    <?php endif; 
                    if(!empty($googleplus_url)): 
                    ?>
                    <li>
                    <a href="<?php echo esc_url($googleplus_url);?>" target = "<?php esc_attr_e('_blank','astrologer'); ?>">
                        <img src="<?php echo esc_url($icon_path.'google.svg'); ?>" alt="<?php echo esc_attr__('google','astrologer'); ?>">
                    </a>
                    </li>
                    <?php endif;
                    if(!empty($youtube_url)): ?>
                    <li>
                    <a href="<?php echo esc_url($youtube_url);?>" target = "<?php esc_attr_e('_blank','astrologer'); ?>">
                        <img src="<?php echo esc_url($icon_path.'youtube.svg'); ?>" alt="<?php echo esc_attr__('youtube','astrologer'); ?>">
                    </a>
                    </li>
                    <?php endif;
                    if(!empty($instagram_url)): ?>
                    <li>
                    <a href="<?php echo esc_url($instagram_url);?>" target = "<?php esc_attr_e('_blank','astrologer'); ?>">
                        <img src="<?php echo esc_url($icon_path.'instagram.svg'); ?>" alt="<?php echo esc_attr__('instagram','astrologer'); ?>">
                    </a>
                    </li>
                     <?php endif; ?>
                </ul>
			</div>
		</div>
    <?php
    } 
    public function form( $instance ) {
        $main_site_logo = '';
        if ( isset( $instance[ 'main_site_logo' ] ) ) {
            $main_site_logo = $instance[ 'main_site_logo' ];
        }
        $widget_desc_data = '';
        if ( isset( $instance[ 'widget_desc_data' ] ) ) {
            $widget_desc_data = $instance[ 'widget_desc_data' ];
        }
        $social_title = '';
        if ( isset( $instance[ 'social_title' ] ) ) {
            $social_title = $instance[ 'social_title' ];
        }
        $facebook_url = '';
        if ( isset( $instance[ 'facebook_url' ] ) ) {
            $facebook_url = $instance[ 'facebook_url' ];
        }
        $twitter_url = '';
        if ( isset( $instance[ 'twitter_url' ] ) ) {
            $twitter_url = $instance[ 'twitter_url' ];
        }
         $googleplus_url = '';
        if ( isset( $instance[ 'googleplus_url' ] ) ) {
            $googleplus_url = $instance[ 'googleplus_url' ];
        }
        $youtube_url = '';
        if ( isset( $instance[ 'youtube_url' ] ) ) {
            $youtube_url = $instance[ 'youtube_url' ];
        }
        $instagram_url = '';
        if ( isset( $instance['instagram_url'] ) ) {
            $instagram_url = $instance['instagram_url'];
        }
       
        ?>  
        <p class="img-prev">
            <?php 
            if (isset($main_site_logo)) { 
                echo '<img src="'.esc_url($main_site_logo).'" class="window_image_url" with="100" height="100"/>';
            } 
            ?>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('main_site_logo'); ?>">
                <?php esc_html_e('upload Image', 'astrologer') ?>
            </label> 
            <input  id="<?php echo $this->get_field_id('main_site_logo'); ?>" type="hidden" class="upload-logo-image-text" name="<?php echo $this->get_field_name('main_site_logo'); ?>" value="<?php if (isset($main_site_logo)) echo esc_attr($main_site_logo); ?>"/>
            <input data-title="<?php esc_attr_e('Image','astrologer'); ?>" data-btntext="<?php esc_attr_e('Select it','astrologer'); ?>" class="button upload-logo-image-button" type="button" value="<?php esc_attr_e('Upload','astrologer') ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'widget_desc_data' )); ?>">
                <?php esc_html_e( 'Text Content :','astrologer'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_desc_data' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'widget_desc_data' )); ?>" type="text" value="<?php echo esc_attr($widget_desc_data); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'social_title' )); ?>">
                <?php esc_html_e( 'Social Title :','astrologer'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'social_title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'social_title' )); ?>" type="text" value="<?php echo esc_attr($social_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'facebook_url' )); ?>">
                <?php esc_html_e( 'Facebook URL :','astrologer'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'facebook_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'facebook_url' )); ?>" type="text" value="<?php echo esc_attr($facebook_url); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'twitter_url' )); ?>">
                <?php esc_html_e( 'Twitter URL :','astrologer'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'twitter_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'twitter_url' )); ?>" type="text" value="<?php echo esc_attr($twitter_url); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'googleplus_url' )); ?>">
                <?php esc_html_e( 'Google Plus URL :','astrologer'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'googleplus_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'googleplus_url' )); ?>" type="text" value="<?php echo esc_attr($googleplus_url); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'youtube_url' )); ?>">
                <?php esc_html_e( 'Youtube URL :','astrologer'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'youtube_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'youtube_url' )); ?>" type="text" value="<?php echo esc_attr($youtube_url); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'instagram_url' )); ?>">
                <?php esc_html_e( 'Instagram_url URL :','astrologer'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'instagram_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'instagram_url' )); ?>" type="text" value="<?php echo esc_attr($instagram_url); ?>" />
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['main_site_logo'] = ( ! empty( $new_instance['main_site_logo'] ) ) ? strip_tags( $new_instance['main_site_logo'] ) : '';
        $instance['widget_desc_data'] = ( ! empty( $new_instance['widget_desc_data'] ) ) ? strip_tags( $new_instance['widget_desc_data'] ) : '';
        $instance['social_title'] = ( ! empty( $new_instance['social_title'] ) ) ? strip_tags( $new_instance['social_title'] ) : '';
        $instance['facebook_url'] = ( ! empty( $new_instance['facebook_url'] ) ) ? strip_tags( $new_instance['facebook_url'] ) : '';
        $instance['twitter_url'] = ( ! empty( $new_instance['twitter_url'] ) ) ? strip_tags( $new_instance['twitter_url'] ) : '';
        $instance['googleplus_url'] = ( ! empty( $new_instance['googleplus_url'] ) ) ? strip_tags( $new_instance['googleplus_url'] ) : '';
        $instance['youtube_url'] = ( ! empty( $new_instance['youtube_url'] ) ) ? strip_tags( $new_instance['youtube_url'] ) : '';
        $instance['instagram_url'] = ( ! empty( $new_instance['instagram_url'] ) ) ? strip_tags( $new_instance['instagram_url'] ) : '';
        return $instance;
    }
}

/**
 * Astrologer Widget Menu
 *
 */ 
class astrologer_widget_menu extends WP_Widget {
    
    function  __construct() {
    	parent::__construct(
    		'astrologer_widget_menu', // Base ID of your widget
    		 esc_html__('Astrologer Menu Option', 'astrologer'),  // Widget name will appear in UI
    		   array( 'description' => esc_html__( 'astrologer Menu Option', 'astrologer' ), ) // Widget description
    		 ); 
    }  

    public function widget( $args, $instance ) {
        $app_widget_title = '';
        if ( isset( $instance[ 'app_widget_title' ] ) ) {
            $app_widget_title = $instance[ 'app_widget_title' ];
        }
        $nav_menu = ! empty( $instance['nav_menu'] ) ? wp_get_nav_menu_object( $instance['nav_menu'] ) : false;
        if (!$nav_menu):
        return;
        endif; 
        ?>
        <div class="al-footer-widget">
            <h3 class="widget-title"><?php echo esc_html($app_widget_title); ?></h3>
            <?php wp_nav_menu( array( 'menu' => $nav_menu,'link_before' => '<span><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid" width="8" height="12" viewBox="0 0 8 12"> <path d="M8.000,5.998 L-0.002,11.997 L1.292,5.998 L-0.002,-0.001 L8.000,5.998 ZM1.265,9.924 L6.502,5.998 L1.265,2.071 L2.112,5.998 L1.265,9.924 ZM5.451,5.998 L2.496,8.213 L2.974,5.998 L2.496,3.783 L5.451,5.998 Z" class="cls-1"></path> </svg></span>') ); ?>
        </div>
        <?php
    }

    public function form( $instance ) {
        $app_widget_title = '';
        if ( isset( $instance[ 'app_widget_title' ]) ) {
            $app_widget_title = $instance[ 'app_widget_title' ];
        }
        $nav_menu = '';
        if ( isset( $instance[ 'nav_menu' ] ) ) {
          $nav_menu = $instance[ 'nav_menu' ];
        }
        $menus = get_terms('nav_menu', array( 'hide_empty' => false ) );
            if ( !$menus ):
               echo '<p>'. sprintf( esc_html__('No menus have been created yet.<a href="%s">Create some</a>.'), admin_url('nav-menus.php') ) .'</p>';
            return;
	    endif;
        ?>
        <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'app_widget_title' )); ?>">
            <?php esc_html_e( 'Title:','astrologer'); ?>
        </label> 
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'app_widget_title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'app_widget_title' )); ?>" type="text" value="<?php echo esc_attr( $app_widget_title ); ?>" />
        </p>
        
        <p>
        <label for="<?php echo $this->get_field_id('nav_menu'); ?>">
            <?php esc_html_e('Select Menu:','astrologer'); ?></label>
        <select id="<?php echo $this->get_field_id('nav_menu'); ?>" name="<?php echo $this->get_field_name('nav_menu'); ?>">
        <?php
        foreach ( $menus as $menu ):
          $selected = $nav_menu == $menu->term_id ? ' selected="selected"' : '';
          echo '<option'.esc_attr($selected).' value="'.esc_attr($menu->term_id).'">'.esc_html($menu->name).'</option>';
        endforeach;  
        ?>
        </select>
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['app_widget_title'] = ( ! empty( $new_instance['app_widget_title'] ) ) ? strip_tags( $new_instance['app_widget_title'] ) : '';
        $instance['nav_menu'] = ( ! empty( $new_instance['nav_menu'] ) ) ? strip_tags( $new_instance['nav_menu'] ) : '';
        return $instance;
    }
}

/**
 * Astrologer Recent Post
 **/ 
class astrologer_widget_recentpost extends WP_Widget {
     
    function  __construct() {
        parent::__construct(
    	    'astrologer_widget_recentpost', // Base ID of your widget
    		esc_html__('Astrologer Recent Post', 'astrologer'),  // Widget name will appear in UI
    		array( 'description' => esc_html__( 'astrologer Recent Post', 'astrologer' ), ) // Widget description
		   );
    } 
	
	public function widget( $args, $instance ) {
	
		$app_widget_title = '';
		if ( isset( $instance[ 'app_widget_title' ] ) ) {
			$app_widget_title = $instance[ 'app_widget_title' ];
		} 
		
		$app_widget_number = '';
		if ( isset( $instance[ 'app_widget_number' ] ) ) {
		   $app_widget_number = $instance[ 'app_widget_number' ];
		}   
    ?>
    <section class="al-recent-post-widgets widget">
		<h3 class="widget-title"><?php echo esc_html($app_widget_title); ?></h3>
        <ul>
            <?php
            $args = array(
                'post_type' =>'post',
                'posts_per_page' => $app_widget_number,
                'post_status' =>'publish',
                );
            $astrologer = new WP_Query($args);
            if($astrologer->have_posts()) :
                while($astrologer->have_posts()) : $astrologer->the_post();
                if(has_post_thumbnail(get_the_ID())):
                    $attachment_url = wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()), 'full');
                endif;	
            ?>
            <li>
                <?php if(!empty($attachment_url)): ?>
                <img src="<?php echo esc_url($attachment_url); ?>" alt="<?php esc_attr_e('image','astrologer'); ?>">
                <?php endif; ?>
                <a href="<?php echo esc_url(get_the_permalink(get_the_ID())); ?>">
                    <p class="al-widget-post-title mb-0">
					<?php
					echo substr(get_the_title(), 0, 40); 
					?>
					</p>
                </a>
            </li>
            <?php
             endwhile;
            endif;
            ?>
        </ul>
    </section>
	<?php
    }
    public function form( $instance ) {
		
        $app_widget_title = '';
        if(isset( $instance[ 'app_widget_title' ] ) ) {
            $app_widget_title = $instance[ 'app_widget_title' ];
        } 
		
        $app_widget_number = '';
        if(isset( $instance[ 'app_widget_number' ] ) ) {
           $app_widget_number = $instance[ 'app_widget_number' ];
        }  
    ?> 
    <p>
    <label for="<?php echo esc_attr($this->get_field_id( 'app_widget_title' )); ?>">
    <?php esc_html_e( 'Title:','astrologer'); ?></label> 
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'app_widget_title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'app_widget_title' )); ?>" type="text" value="<?php echo esc_attr( $app_widget_title ); ?>" />
    </p>
    <p>
    <label for="<?php echo esc_attr($this->get_field_id( 'app_widget_number' )); ?>">
    <?php esc_html_e( 'Show No.of Post :','astrologer'); ?></label> 
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'app_widget_number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'app_widget_number' )); ?>" type="text" value="<?php echo esc_attr( $app_widget_number ); ?>" />
    </p>
    <?php
    }
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['app_widget_title'] = ( ! empty( $new_instance['app_widget_title'] ) ) ? strip_tags( $new_instance['app_widget_title'] ) : '';
        $instance['app_widget_number'] = ( ! empty( $new_instance['app_widget_number'] ) ) ? strip_tags( $new_instance['app_widget_number'] ) : '';
        return $instance;  
    }
}



/**
 * Astrologer Custom Image Widget
**/ 
class astrologer_widget_image extends WP_Widget {
    function  __construct() {
    	parent::__construct(
        'astrologer_widget_image', // Base ID of your widget
            esc_html__('Astrologer Image', 'astrologer'),  // Widget name will appear in UI
            array( 'description' => esc_html__( 'Astrologer Image', 'astrologer' ), ) // Widget description
            );
    }

    public function widget( $args, $instance ) {
        $widgets_custom_img = '';
        if ( isset( $instance[ 'widgets_custom_img' ] ) ) {
            $widgets_custom_img = $instance[ 'widgets_custom_img' ];
        }
        ?>
        <div class="al-custom-img-section">
            <?php if(!empty($widgets_custom_img)): ?>
                <div class="al-custom-img">
                    <a href="<?php echo esc_url(home_url('/')); ?>">
                        <img src="<?php echo esc_url($widgets_custom_img); ?>" alt="<?php esc_attr_e('Astrologer WordPress Theme','astrologer'); ?>" />
                    </a>                    
                </div>
            <?php endif; ?>
        </div>
    <?php

    }    
    public function form( $instance ) {
        $widgets_custom_img = '';
        if ( isset( $instance[ 'widgets_custom_img' ] ) ) {
            $widgets_custom_img = $instance[ 'widgets_custom_img' ];
        }       
        ?>  
        <p class="img-prev">
            <?php 
            if (isset($widgets_custom_img)) { 
                echo '<img src="'.esc_url($widgets_custom_img).'" class="window_image_url" with="100" height="100"/>';
            } 
            ?>
        </p>
        <p>
        <label for="<?php echo $this->get_field_id('widgets_custom_img'); ?>">
        <?php esc_html_e('upload Image', 'astrologer') ?>
        </label> 
        <input  id="<?php echo $this->get_field_id('widgets_custom_img'); ?>" type="text" class="upload-logo-image-text" name="<?php echo $this->get_field_name('widgets_custom_img'); ?>" value="<?php if (isset($widgets_custom_img)) echo esc_attr($widgets_custom_img); ?>"/>
        <input data-title="<?php esc_attr_e('Image','astrologer'); ?>" data-btntext="<?php esc_attr_e('Select it','astrologer'); ?>" class="button upload-logo-image-button" type="button" value="<?php esc_attr_e('Upload','astrologer') ?>" />
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
		$instance['widgets_custom_img'] = ( ! empty( $new_instance['widgets_custom_img'] ) ) ? strip_tags( $new_instance['widgets_custom_img'] ) : '';
        return $instance;
    }
}  

class astrologercore_widget_Contact extends WP_Widget {
    function  __construct() {
    	parent::__construct(
        'astrologercore_widget_Contact', // Base ID of your widget
            esc_html__('Astrologer Contat Info', 'astrologer'),  // Widget name will appear in UI
            array( 'description' => esc_html__( 'Astrologer Contat Info', 'astrologer' ), ) // Widget description
            );
    }
	public function widget( $args, $instance ) {
        $icon_path = plugin_dir_url( dirname( __FILE__ ) ).'/widgets/images/';
		
		$app_widget_title = '';
        if ( isset( $instance[ 'app_widget_title' ] ) ) {
            $app_widget_title = $instance[ 'app_widget_title' ];
        }
		
        $widget_address = '';
        if ( isset( $instance[ 'widget_address' ] ) ) {
            $widget_address = $instance[ 'widget_address' ];
        }
        $widget_email_one = '';
        if ( isset( $instance[ 'widget_email_one' ] ) ) {
            $widget_email_one = $instance[ 'widget_email_one' ];
        }
        $widget_email_two = '';
        if ( isset( $instance[ 'widget_email_two' ] ) ) {
            $widget_email_two = $instance[ 'widget_email_two' ];
        }
        $widget_phone_one = '';
        if ( isset( $instance[ 'widget_phone_one' ] ) ) {
            $widget_phone_one = $instance[ 'widget_phone_one' ];
        }
         $widget_phone_two = '';
        if ( isset( $instance[ 'widget_phone_two' ] ) ) {
            $widget_phone_two = $instance[ 'widget_phone_two' ];
        }
        ?>
		<div class="al-footer-widget">
			<h3 class="widget-title"><?php echo esc_html($app_widget_title); ?></h3>
            <ul class="al-contact-list">
                <li>
				<img src="<?php echo esc_url($icon_path); ?>map.svg" alt="<?php esc_attr_e('map','astrologer'); ?>">
				<?php if(!empty($widget_address)): ?>
					<p><?php echo esc_html($widget_address); ?></p>
				<?php endif; ?>
                </li>
                <li>
				<img src="<?php echo esc_url($icon_path);?>address.svg" alt="<?php esc_attr_e('address','astrologer'); ?>">
				<p>
				<?php if(!empty($widget_email_one)): ?>
					<a href="mailto:<?php echo esc_html($widget_email_one); ?>"><?php echo esc_html($widget_email_one); ?></a>
				<?php endif; ?>
				<?php if(!empty($widget_email_two)): ?>
					<a href="mailto:<?php echo esc_html($widget_email_one); ?>"><?php echo esc_html($widget_email_two); ?></a>
				<?php endif; ?>
				</p>
                </li> 
                <li>
				<img src="<?php echo esc_url($icon_path) ?>call.svg" alt="<?php esc_attr_e('call','astrologer'); ?>">
				<p>
				<?php if(!empty($widget_phone_one)): ?>
					<a href="tel:<?php echo esc_attr($widget_phone_one); ?>"><?php echo esc_html($widget_phone_one); ?></a>
				<?php endif; ?>
				<?php if(!empty($widget_phone_two)): ?>
					<a href="tel:<?php echo esc_attr($widget_phone_two);?>"><?php echo esc_html($widget_phone_two); ?></a>
				<?php endif; ?>
				</p>
                </li>
            </ul>
        </div>
    <?php
    } 
	public function form( $instance ) {
		$app_widget_title = '';
        if (isset($instance['app_widget_title'])) {
            $app_widget_title = $instance['app_widget_title'];
        }
        $widget_address = '';
        if ( isset( $instance[ 'widget_address' ] ) ) {
            $widget_address = $instance[ 'widget_address' ];
        }
        $widget_email_one = '';
        if ( isset( $instance[ 'widget_email_one' ] ) ) {
            $widget_email_one = $instance[ 'widget_email_one' ];
        }
        $widget_email_two = '';
        if ( isset( $instance[ 'widget_email_two' ] ) ) {
            $widget_email_two = $instance[ 'widget_email_two' ];
        }
        $widget_phone_one = '';
        if ( isset( $instance[ 'widget_phone_one' ] ) ) {
            $widget_phone_one = $instance[ 'widget_phone_one' ];
        }
        $widget_phone_two = '';
        if ( isset( $instance[ 'widget_phone_two' ] ) ) {
            $widget_phone_two = $instance[ 'widget_phone_two' ];
        }       
        ?>  
		<p>
		<label for="<?php echo esc_attr($this->get_field_id( 'app_widget_title' )); ?>">
		   <?php esc_html_e( 'Title :','astrologer'); ?>
		</label>
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'app_widget_title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'app_widget_title' )); ?>" type="text" value="<?php echo esc_attr($app_widget_title); ?>" />
        </p>
        <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'widget_address' )); ?>">
            <?php esc_html_e( 'Address :','astrologer'); ?>
        </label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_address' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'widget_address' )); ?>" type="text" value="<?php echo esc_attr($widget_address); ?>" />
        </p>
        <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'widget_email_one' )); ?>">
            <?php esc_html_e( 'Email Address One :','astrologer'); ?>
        </label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_email_one' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'widget_email_one' )); ?>" type="text" value="<?php echo esc_attr($widget_email_one); ?>" />
        </p>
        <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'widget_email_two' )); ?>">
            <?php esc_html_e( 'Email Address Two:','astrologer'); ?>
        </label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_email_two' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'widget_email_two' )); ?>" type="text" value="<?php echo esc_attr($widget_email_two); ?>" />
        </p>
        <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'widget_phone_one' )); ?>">
            <?php esc_html_e( 'Phone Number one :','astrologer'); ?>
        </label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_phone_one' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'widget_phone_one' )); ?>" type="text" value="<?php echo esc_attr($widget_phone_one); ?>" />
        </p>
        <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'widget_phone_two' )); ?>">
                <?php esc_html_e( 'Phone Number Two :','astrologer'); ?>
        </label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_phone_two' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'widget_phone_two' )); ?>" type="text" value="<?php echo esc_attr($widget_phone_two); ?>" />
        </p>
    <?php
    }
	public function update( $new_instance, $old_instance ) {
        $instance = array();
		$instance['app_widget_title'] = ( ! empty( $new_instance['app_widget_title'] ) ) ? strip_tags( $new_instance['app_widget_title'] ) : '';
		$instance['widget_address'] = ( ! empty( $new_instance['widget_address'] ) ) ? strip_tags( $new_instance['widget_address'] ) : '';
        $instance['widget_email_one'] = ( ! empty( $new_instance['widget_email_one'] ) ) ? strip_tags( $new_instance['widget_email_one'] ) : '';
        $instance['widget_email_two'] = ( ! empty( $new_instance['widget_email_two'] ) ) ? strip_tags( $new_instance['widget_email_two'] ) : '';
        $instance['widget_phone_one'] = ( ! empty( $new_instance['widget_phone_one'] ) ) ? strip_tags( $new_instance['widget_phone_one'] ) : '';
        $instance['widget_phone_two'] = ( ! empty( $new_instance['widget_phone_two'] ) ) ? strip_tags( $new_instance['widget_phone_two'] ) : '';
        return $instance;
    }
	
} 

/**
 * Top header Contat Info Widget
 */ 
class astrologercore_top_header_contact_info extends WP_Widget {
    
    function  __construct() {
    	parent::__construct(
        'astrologercore_top_header_contat_info', // Base ID of your widget
            esc_html__('Astrologer Top Header Contact Info', 'astrologer'),  // Widget name will appear in UI
            array( 'description' => esc_html__( 'Astrologer Contat Info', 'astrologer' ), ) // Widget description
            );
    }
    public function widget( $args, $instance ) {
        
    $icon_headphone = plugin_dir_url( dirname( __FILE__ ) ).'/widgets/images/headphone.svg';
    $icon_mail = plugin_dir_url( dirname( __FILE__ ) ).'/widgets/images/mail1.svg';
    $widget_phone_title = '';
    if(isset( $instance[ 'widget_phone_title' ] ) ) {
        $widget_phone_title = $instance[ 'widget_phone_title' ];
    }    
    $widget_phone_number = '';
    if(isset( $instance[ 'widget_phone_number' ] ) ) {
        $widget_phone_number = $instance[ 'widget_phone_number' ];
    }  
    
    $widget_email_title = '';
    if(isset( $instance[ 'widget_email_title' ] ) ) {
        $widget_email_title = $instance[ 'widget_email_title' ];
    }    
    $widget_email_address = '';
    if(isset( $instance[ 'widget_email_address' ] ) ) {
        $widget_email_address = $instance[ 'widget_email_address' ];
    }    
    echo $args['before_widget'];
    ?>
    <ul> 
        <li>
        <?php
            if (!empty($widget_phone_number)) {
        ?>
        <a href="tel:<?php echo esc_attr($widget_phone_number); ?>">
            <div class="al-infobox">
            <span class="al-infoicon">
                <img src="<?php echo esc_url($icon_headphone); ?>" alt="<?php echo esc_attr__('Astrogers Phone','astrologer'); ?>">
            </span>
            <span class="al-orange"><?php echo esc_html($widget_phone_title); ?></span> <?php echo esc_html($widget_phone_number); ?>
            </div>
        </a>
        <?php
            }
         ?>
        </li>
        <li>
          <?php
            if (!empty($widget_email_address)) {
        ?>   
        <a href="mailto:<?php echo esc_attr($widget_email_address); ?>">
            <div class="al-infobox">
            <span class="al-infoicon">
             <img src="<?php echo esc_url($icon_mail); ?>" alt="<?php echo esc_attr__('Astrogers Email','astrologer'); ?>">
            </span>
            <span class="al-orange"><?php echo esc_html($widget_email_title); ?></span><?php echo esc_html($widget_email_address); ?>
            </div>
        </a>
        <?php
            }
         ?>
        </li>
    </ul>
    <?php
    echo $args['after_widget'];
    }
    public function form( $instance ) {
        
    $widget_phone_title = '';
    if(isset( $instance[ 'widget_phone_title' ] ) ) {
        $widget_phone_title = $instance[ 'widget_phone_title' ];
    }    
    $widget_phone_number = '';
    if(isset( $instance[ 'widget_phone_number' ] ) ) {
        $widget_phone_number = $instance[ 'widget_phone_number' ];
    }  
    
    $widget_email_title = '';
    if(isset( $instance[ 'widget_email_title' ] ) ) {
        $widget_email_title = $instance[ 'widget_email_title' ];
    }    
    $widget_email_address = '';
    if(isset( $instance[ 'widget_email_address' ] ) ) {
        $widget_email_address = $instance[ 'widget_email_address' ];
    }    
    
    ?>
    <p>
    <label for="<?php echo esc_attr($this->get_field_id( 'widget_phone_title' )); ?>">
        <?php esc_html_e( 'Phone Number Title :','astrologer'); ?>
    </label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_phone_title')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_phone_title')); ?>" type="text" value="<?php echo esc_attr($widget_phone_title); ?>" />
    </p>
    <p>
    <label for="<?php echo esc_attr($this->get_field_id( 'widget_phone_number' )); ?>">
    <?php esc_html_e( 'Phone Number  :','astrologer'); ?>
    </label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_phone_number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'widget_phone_number' )); ?>" type="text" value="<?php echo esc_attr($widget_phone_number); ?>" />
    </p>
    
    <p>
    <label for="<?php echo esc_attr($this->get_field_id( 'widget_email_title' )); ?>">
        <?php esc_html_e( 'Phone Email Title :','astrologer'); ?>
    </label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_email_title')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_email_title')); ?>" type="text" value="<?php echo esc_attr($widget_email_title); ?>" />
    </p>
    <p>
    <label for="<?php echo esc_attr($this->get_field_id( 'widget_email_address' )); ?>">
    <?php esc_html_e( 'Phone Email Address :','astrologer'); ?>
    </label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'widget_email_address' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'widget_email_address' )); ?>" type="text" value="<?php echo esc_attr($widget_email_address); ?>" />
    </p> 
    <?php
    
    }
    public function update( $new_instance, $old_instance ) {
        
        $instance['widget_phone_title'] = ( ! empty( $new_instance['widget_phone_title'] ) ) ? strip_tags( $new_instance['widget_phone_title'] ) : '';
        $instance['widget_phone_number'] = ( ! empty( $new_instance['widget_phone_number'] ) ) ? strip_tags( $new_instance['widget_phone_number'] ) : '';
        
        $instance['widget_email_title'] = ( ! empty( $new_instance['widget_email_title'] ) ) ? strip_tags( $new_instance['widget_email_title'] ) : '';
        $instance['widget_email_address'] = ( ! empty( $new_instance['widget_email_address'] ) ) ? strip_tags( $new_instance['widget_email_address'] ) : '';
        
        return $instance;
    }
} 

/**
 * Top Heade Profile Widget
 */ 
class astrologercore_top_header_profile extends WP_Widget {
    
    function  __construct() {
    	parent::__construct(
        'astrologercore_top_header_profile', // Base ID of your widget
            esc_html__('Astrologer Profile Setting', 'astrologer'),  // Widget name will appear in UI
            array( 'description' => esc_html__( 'Astrologer Profile Setting', 'astrologer' ), ) // Widget description
            );
    }
    public function widget( $args, $instance ) {
        
    $icon_path = plugin_dir_url( dirname( __FILE__ ) ).'/widgets/images/login.svg';    
    $icon_path2 = plugin_dir_url( dirname( __FILE__ ) ).'/widgets/images/logout.svg';    
    $page_title = '';
    if(isset( $instance['page_title'] ) ):
       $page_title = $instance['page_title'];
    endif;
    $page_url = '';
    if(isset( $instance['page_url'] ) ):
       $page_url = $instance['page_url'];
    endif;
    $logout_url = wp_logout_url(home_url());
    echo $args['before_widget'];
    ?>
    <div class="al-user-profile">
      <?php if(is_user_logged_in()): ?>
         <a href="<?php echo esc_url($logout_url); ?>">
             <span class="al-infoicon">
			  <img src="<?php echo esc_url($icon_path2); ?>" alt="<?php echo esc_attr_e('Logout','astrologer'); ?>">
		    </span>
            <span class="al-logintext"><?php echo esc_html__('Logout','astrologer'); ?></span>
        </a>
      <?php else: ?>
         <a href="<?php echo esc_url($page_url); ?>">
            <span class="al-infoicon">
			  <img src="<?php echo esc_url($icon_path); ?>" alt="<?php echo esc_attr_e('Login / Register','astrologer'); ?>">
		    </span>
            <span class="al-logintext"><?php echo esc_html($page_title); ?></span>
         </a>
      <?php endif; ?>
    </div>
    <?php
    echo $args['after_widget'];
    }
    public function form( $instance ) {
    $page_title = '';
    if(isset( $instance['page_title'] ) ):
       $page_title = $instance['page_title'];
    endif;
    $page_url = '';
    if(isset( $instance['page_url'] ) ):
       $page_url = $instance['page_url'];
    endif;
    ?>
    <p>
    <label for="<?php echo esc_attr($this->get_field_id('page_title')); ?>">
      <?php esc_html_e('Page Title :','astrologer'); ?>
    </label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id('page_title')); ?>" name="<?php echo esc_attr($this->get_field_name('page_title')); ?>" type="text" value="<?php echo esc_attr($page_title); ?>" />
    <label for="<?php echo esc_attr($this->get_field_id('page_url')); ?>">
     <?php esc_html_e('Page Url :','astrologer'); ?>
    </label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id('page_url')); ?>" name="<?php echo esc_attr($this->get_field_name('page_url')); ?>" type="text" value="<?php echo esc_attr($page_url); ?>" />
    </p>
    <?php    
    }
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['page_title'] = ( ! empty( $new_instance['page_title'] ) ) ? strip_tags( $new_instance['page_title'] ) : '';
        $instance['page_url'] = ( ! empty( $new_instance['page_url'] ) ) ? strip_tags( $new_instance['page_url'] ) : '';
        return $instance;
    }
}  

/**
 * Top MinCart Widget
 */ 
class astrologercore_top_header_mincart extends WP_Widget {
    
    function  __construct() {
    	parent::__construct(
        'astrologercore_top_header_mincart', // Base ID of your widget
            esc_html__('Astrologer Top Header MinCart', 'astrologer'),  // Widget name will appear in UI
            array( 'description' => esc_html__( 'Astrologer Top Header MinCart', 'astrologer'), ) // Widget description
            );
    }
    public function widget( $args, $instance ) {
    $icon_path = plugin_dir_url( dirname( __FILE__ ) ).'/widgets/images/cart.svg';
    echo $args['before_widget'];
    if(class_exists('WooCommerce')):
    global $pagenow;
    if($pagenow === 'widgets.php'):
    ?>
    <div class="al-cart-wrapper">
     <?php echo esc_html__('working on','astrologer'); ?>
    </div>
    <?php
    else:
    if(is_checkout() || is_cart()):
    ?>
    <div class="al-cart-wrapper">
        <a href="<?php echo esc_url(wc_get_cart_url()); ?>">
        <div class="al-cart">
            <span class="al-cart-icon">
                <img src="<?php echo esc_url($icon_path); ?>" alt="<?php echo esc_attr__('cart','astrologer'); ?>">
                <span class="al-cartnumber">
                    <?php 
                    $contents_count = '';
                    if(class_exists('WooCommerce') && is_page()):
                         $contents_count = WC()->cart->get_cart_contents_count();
                    endif;
                    printf(esc_html__('%s', 'astrologer' ),$contents_count);
                    ?>
                </span>
			</span>
            <?php  echo WC()->cart->get_cart_total();?>
          </div>
        </a>
    </div>
    <?php
    else:
    ?>
    <div class="al-cart-wrapper">
        <div class="al-cart">
            <span class="al-cart-icon">
                <img src="<?php echo esc_url($icon_path); ?>" alt="<?php echo esc_attr__('cart','astrologer'); ?>">
                <span class="al-cartnumber">
                    <?php 
                    $contents_count = '';
                    if(class_exists('WooCommerce') && is_page()):
                       $contents_count = WC()->cart->get_cart_contents_count();
                    else:
                       if(is_shop()):
			             $contents_count = WC()->cart->get_cart_contents_count();
			            elseif(is_singular()):
			                $contents_count = WC()->cart->get_cart_contents_count();
			           endif;
                    endif;
                    printf(esc_html__('%s', 'astrologer' ),$contents_count);
                    ?>
                </span>
			</span>
            <?php  
            if(class_exists('WooCommerce') && is_page()):
              echo WC()->cart->get_cart_total(); 
              
            endif;
            ?>
        </div>
        <div class="al-cart-box">
			<div class="al-cart-list">
			  <?php 
			  if(class_exists('WooCommerce') && is_page()):
				woocommerce_mini_cart();
			  else:
			      if(is_shop()):
			        woocommerce_mini_cart();  
			      endif;
			  endif;
			  ?>
			</div>
		</div>
    </div>  
    <?php
      endif;
    endif;
    endif;
    echo $args['after_widget'];
    }
    public function form( $instance ) {
    ?>  
    
    <?php    
    }
    public function update( $new_instance, $old_instance ) {
        
        
    }
}  
/**
 * App Download Widget
 */ 
class astrologercore_widget_app_download extends WP_Widget {

function  __construct() {

	parent::__construct(
		   'astrologercore_widget_app_download', // Base ID of your widget
		   esc_html__('Astrologer Apps download', 'astrologer'),  // Widget name will appear in UI
		   array( 'description' => esc_html__( 'Store button widget', 'astrologer' ), ) // Widget description
		  );
}
public function widget( $args, $instance ) {
    $aap_logo = ( ! empty( $instance['app_logo'] ) ) ? $instance['app_logo'] : '';
    $app_title = apply_filters( 'app_title', $instance['app_title'] );
    $gplay_url = apply_filters( 'widget_gplay_url', $instance['gplay_url'] );
    $gplay_image_url = '';
        if ( isset( $instance[ 'gplay_image_url' ] ) ) {
            $gplay_image_url = $instance[ 'gplay_image_url' ];
        }
    $apple_url = apply_filters( 'widget_apple_url', $instance['apple_url'] );
    $apple_image_url = ( ! empty( $instance['apple_image_url'] ) ) ? $instance['apple_image_url'] : '';
    // before and after widget arguments are defined by themes
    echo __($args['before_widget']); ?>

    <div class="al-app-downlod-options text-center">
        <a href="<?php echo esc_url(home_url('/')); ?>" class="al-site-widget-logo">
			<img src="<?php echo esc_url($aap_logo); ?>" alt="<?php esc_attr_e('logo','astrologer'); ?>" />
		</a>
        <h3><?php echo esc_html($app_title); ?></h3>
    <?php if ( ! empty( $gplay_url ) ) { ?>

    	<a href="<?php echo esc_url($gplay_url); ?>"  class="al-playstore-iocns"><img src="<?php echo esc_url($gplay_image_url); ?>" alt="<?php esc_attr_e('Google Play', 'astrologer'); ?>" class="img-fluid"></a>

    <?php } if( ! empty( $apple_url ) ) { ?>

    	<a href="<?php echo esc_url($apple_url); ?>" class="al-playstore-iocns al-last-img"><img src="<?php echo esc_url($apple_image_url); ?>" alt="<?php esc_attr_e('App Store', 'astrologer'); ?>" class="img-fluid"></a>

    <?php } ?>

    </div>
    <?php  
    echo __($args['after_widget']);

}

// Widget Backend 
    public function form( $instance ) {
        $app_logo = '';
        if ( isset( $instance[ 'app_logo' ] ) ) {
            $app_logo = $instance[ 'app_logo' ];
        }
        $app_title = '';
        if ( isset( $instance[ 'app_title' ] ) ) {
            $app_title = $instance[ 'app_title' ];
        }
        $gplay_url = '';
        if ( isset( $instance[ 'gplay_url' ] ) ) {
            $gplay_url = $instance[ 'gplay_url' ];
        }
        $gplay_image_url = '';
        if ( isset( $instance[ 'gplay_image_url' ] ) ) {
            $gplay_image_url = $instance[ 'gplay_image_url' ];
        }
        $apple_url = '';
        if ( isset( $instance[ 'apple_url' ] ) ) {
            $apple_url = $instance[ 'apple_url' ];
        }
        $apple_image_url = '';
        if ( isset( $instance[ 'apple_image_url' ] ) ) {
            $apple_image_url = $instance[ 'apple_image_url' ];
        }
    ?>
    <p class="img-prev">
            <?php 
            if (isset($app_logo)) { 
                echo '<img src="'.esc_url($app_logo).'" class="widgets_app_img" with="100" height="100"/>';
            } 
            ?>
    </p>
    <p>
        <label for="<?php echo $this->get_field_id('app_logo'); ?>">
            <?php esc_html_e('Upload Logo Image', 'astrologer') ?>
         </label> 
        <input  id="<?php echo $this->get_field_id('app_logo'); ?>" type="hidden" class="app-upload-logo" name="<?php echo $this->get_field_name('app_logo'); ?>" value="<?php if (isset($app_logo)) echo esc_attr($app_logo); ?>"/>
        <input data-title="<?php esc_attr_e('Image','astrologer'); ?>" data-btntext="<?php esc_attr_e('Select it','astrologer'); ?>" class="button upload-app-logo-img" type="button" value="<?php esc_attr_e('Upload','astrologer') ?>" />
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'app_title' )); ?>">
            <?php esc_html_e( 'Title:','astrologer'); ?>
        </label> 
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'app_title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'app_title' )); ?>" type="text" value="<?php echo esc_attr( $app_title ); ?>" />
    </p>
    <p>
        <label for="<?php echo $this->get_field_id('gplay_image_url'); ?>">
             <?php esc_html_e('Upload Google Play Image', 'astrologer') ?>:</label>
        <input  id="<?php echo $this->get_field_id('gplay_image_url'); ?>" type="hidden" class="upload-logo-image-text" name="<?php echo $this->get_field_name('gplay_image_url'); ?>" value="<?php if (isset($gplay_image_url)) echo esc_attr($gplay_image_url); ?>"
        />
        <input data-title="Image" data-btntext="Select it" class="button upload-logo-image-button" type="button" value="<?php esc_attr_e('Upload','astrologer') ?>" />
    </p>
    <p class="img-prev">
    	<?php if (isset($gplay_image_url)) { echo '<img src="'. esc_url($gplay_image_url).'" class="gplay_image_url"';} ?>
    </p>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'gplay_url' )); ?>">
            <?php esc_html_e( 'Google Play Url:','astrologer'); ?></label> 
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'gplay_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'gplay_url' )); ?>" type="text" value="<?php echo esc_attr( $gplay_url ); ?>" />
    </p>
    <p>
        <label for="<?php echo $this->get_field_id('apple_image_url'); ?>">
            <?php esc_html_e('Upload Apple Store Image', 'astrologer') ?>:</label>
        <input  id="<?php echo $this->get_field_id('apple_image_url'); ?>" type="hidden" class="appleimage-url" name="<?php echo $this->get_field_name('apple_image_url'); ?>" value="<?php if (isset($apple_image_url)) echo esc_attr($apple_image_url); ?>"
        />
        <input data-title="Image" data-btntext="Select it" class="button upload-apple-image-button" type="button" value="<?php esc_attr_e('Upload','astrologer') ?>" />
    </p>
    <p class="img-prev">
    	<?php if (isset($apple_image_url)) { echo '<img src="'.esc_url($apple_image_url).'" class="apple_image_url"';} ?>
    </p>
    <p>  
        <label for="<?php echo esc_attr($this->get_field_id( 'apple_url' )); ?>">
            <?php esc_html_e( 'Apple Store Url:','astrologer'); ?></label> 
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'apple_url' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'apple_url' )); ?>" type="text" value="<?php echo esc_attr( $apple_url ); ?>" />
    </p>
    <?php 
    }

    /*Updating widget replacing old instances with new*/
    public function update( $new_instance, $old_instance ) {
    $instance = array();
    $instance['app_logo'] = ( ! empty( $new_instance['app_logo'] ) ) ? strip_tags( $new_instance['app_logo'] ) : '';
    $instance['app_title'] = ( ! empty( $new_instance['app_title'] ) ) ? strip_tags( $new_instance['app_title'] ) : '';

    $instance['gplay_url'] = ( ! empty( $new_instance['gplay_url'] ) ) ? strip_tags( $new_instance['gplay_url'] ) : '';
    $instance['gplay_image_url'] = ( ! empty( $new_instance['gplay_image_url'] ) ) ? strip_tags( $new_instance['gplay_image_url'] ) : '';

    $instance['apple_url'] = ( ! empty( $new_instance['apple_url'] ) ) ? strip_tags( $new_instance['apple_url'] ) : '';
    $instance['apple_image_url'] = ( ! empty( $new_instance['apple_image_url'] ) ) ? strip_tags( $new_instance['apple_image_url'] ) : '';
    return $instance;
    }
} 
