<?php 
/**
 * astrologercore Core Meta Option
 */
add_action( 'add_meta_boxes', 'astrologercore_custom_meta_boxes', 10, 2 );
function astrologercore_custom_meta_boxes( $post_type, $post ) {
    add_meta_box(
        'astrologercore-meta-box',
        __( 'Product Extra Setting','astrologercore'),
        'astrologercore_meta_box',
        array('product'), //post types here
        'normal',
        'high'
    );
}

function astrologercore_meta_box($post) {
    
    $ast_new_product = get_post_meta($post->ID, 'astrologer_new_product', true);
    $ast_checked = '';
    if($ast_new_product == true):
      $ast_checked = esc_html__('checked','astrologercore');
    endif;
    ?>
    <table>
     <tr>
        <td> 
         <label for="ast_new_product"><?php echo esc_html__('Add New Product Tag','astrologercore');?></label>
         <input type="checkbox" id="ast_new_product" name="ast_new_product" value="new" <?php echo esc_attr($ast_checked); ?> >
        </td>
     </tr>
    </table>
<?php
}

add_action('save_post', 'astrologercore_save_postdata');
function astrologercore_save_postdata($post_id)
{
    if(array_key_exists('astrologer_new_product', $_POST)) {
        update_post_meta(
            $post_id,
            'astrologer_new_product',
            $_POST['ast_new_product']
        );
    }
    
    
}   