<?php	
	/************************************************************************
	* Demo Importer:
	* Way to set menu, import revolution slider, and set home page.
	*************************************************************************/
	if ( !function_exists( 'astrolozer_import_stuff' ) ) {
		function astrolozer_import_stuff( $demo_active_import , $demo_directory_path ) {

			reset( $demo_active_import );
			$current_key = key( $demo_active_import );

			/************************************************************************
			* Import slider(s) for the current demo being imported
			*************************************************************************/

			if ( class_exists( 'RevSlider' ) ) {

				//If it's demo1 or demo8
				$wbc_sliders_array = array(
					'demo1' => 'astrology-slider.zip',
					'demo2' => 'version-two-slider.zip',
					'demo4' => 'astrologer-demo4.zip',
					'demo5' => 'astrologer-demo5.zip',
					'demo6' => 'astrologer-demo6.zip',
					'demo9' => 'astrologer-demo9.zip',
					'demo10' => 'slider-1.zip',
				);

				if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_sliders_array ) ) {
					$wbc_slider_import = $wbc_sliders_array[$demo_active_import[$current_key]['directory']];

					if( is_array( $wbc_slider_import ) ){
					foreach ($wbc_slider_import as $slider_zip) {
							if ( !empty($slider_zip) && file_exists( $demo_directory_path.$slider_zip ) ) {
								$slider = new RevSlider();
								$slider->importSliderFromPost( true, true, $demo_directory_path.$slider_zip );
							}
						}
					}else{
						if ( file_exists( $demo_directory_path.$wbc_slider_import ) ) {
							$slider = new RevSlider();
							$slider->importSliderFromPost( true, true, $demo_directory_path.$wbc_slider_import );
						}
					}
				}
			}

			/************************************************************************
			* Setting Menus
			*************************************************************************/

			$wbc_menu_array = array( 'demo1', 'demo2', 'demo3', 'demo4', 'demo5', 'demo6', 'demo7', 'demo8', 'demo9', 'demo10' );

			if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && in_array( $demo_active_import[$current_key]['directory'], $wbc_menu_array ) ) {
				$primary = get_term_by( 'name', 'Main_Menu', 'nav_menu' );
				$mega_menu = get_term_by( 'name', 'Mega Menu', 'nav_menu' );
				$left_menu = get_term_by( 'name', 'Left Menu', 'nav_menu' );
				$right_menu = get_term_by( 'name', 'Right Menu', 'nav_menu' );
				if ( isset( $primary->term_id ) ) {
					set_theme_mod( 'nav_menu_locations', array(
							'astrologer-header-menu' => $primary->term_id,
							'astrologer-footer-menu' => $mega_menu->term_id,
						)
					);
				}
			}

			/************************************************************************
			* Set HomePage
			*************************************************************************/

			// array of demos/homepages to check/select from
			$wbc_home_pages = array(
				'demo1' => 'Home',
				'demo2' => 'Home',
				'demo3' => 'Home',
				'demo4' => 'Home',
				'demo5' => 'Home',
				'demo6' => 'Home',
				'demo7' => 'Home',
				'demo8' => 'Home',
				'demo9' => 'Home',
				'demo10' => 'Home',
			);

			if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_home_pages ) ) {
				$page = get_page_by_title( $wbc_home_pages[$demo_active_import[$current_key]['directory']] );
				if ( isset( $page->ID ) ) {
					update_option( 'page_on_front', $page->ID );
					update_option( 'show_on_front', 'page' );
				}
			}		
		}

		add_action( 'wbc_importer_after_content_import', 'astrolozer_import_stuff', 10, 2 );
	}