<?php
/**
 * @link        #
 * @since       1.0.0
 * @package     astro event management
 * Plugin Name: Astro Event Management
 * Plugin URI:  #
 * Description: Addon plugin of Woocommerce Events Manager 
 * Version:     1.0.0
 * Author:      ASTRO Themes 
 * Author URI:  #
 * License:     GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: astro
 * Domain Path: languages
 */
  
// If this file is called directly, abort.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
//Plugin version constant
define( 'EM_VERSION', '1.0.0' );

add_action( 'wp_enqueue_scripts', 'astro_event_pluginscript_enqueue' );
function astro_event_pluginscript_enqueue(){
   
   wp_enqueue_style('astro-event-custom-style', plugin_dir_url( __FILE__ ) . 'assets/css/astro-event-custom-style.css', array('mep-event-style'), '1', 'all' , true );
}

add_action( 'admin_enqueue_scripts', 'astro_event_pluginscript_denqueue', 11 );
function astro_event_pluginscript_denqueue() {
    wp_dequeue_style( 'mage-jquery-ui-style' );
    wp_dequeue_style( 'jquery-ui' );
}
/**
 * jobsportal custom function
 */ 
require_once plugin_dir_path( __FILE__ ) . 'includes/astro-event-function.php';

/**
 * shortcodes file require
 */ 
require_once plugin_dir_path( __FILE__ ) . 'shortcodes/astro-event-shortcode-map.php';
require_once plugin_dir_path( __FILE__ ) . 'shortcodes/astro-event-shortcode-view.php';

//Plugin Update Funtion
add_action('init', 'astro_events_au');
function astro_events_au(){
    require_once ('wp_autoupdate.php');
    $mt_plugin_remote_path = 'https://astro.co/demos/updates/plugins/update_astro_events.php';
    $mt_plugin_slug = plugin_basename(__FILE__);
    new astro_events_update(EM_VERSION, $mt_plugin_remote_path, $mt_plugin_slug);
}

/**
 * Plugin dependency notice.
*/
function astro_event_notice() {
	if(!class_exists('MAGE_Events_Setting_Controls')){
		echo '<div class="notice notice-error is-dismissible"><p>ASTRO Events plugin is enabled but not effective. It requires <a href="https://wordpress.org/plugins/mage-eventpress/" target="_blank">Woocommerce Events Manager</a> plugin to work.</p></div>';
	}
};
add_action( 'admin_notices', 'astro_event_notice' );