<?php

require_once( dirname(__FILE__) . '/../../../../wp-load.php' ); // WP environment
//wp_head();

// User and schedule information
$user_id = 1;
$bc_table_id = '1';
require_once plugin_dir_path( dirname( __FILE__ ) ). 'Twilio/autoload.php';
$schedule_id = base64_decode($_POST['item_id']); 
$schedule_price = get_post_meta($schedule_id,'appointment_schedule_price',true);

// Check if Razorpay payment ID is set
if(isset($_POST['razorpay_payment_id'])){
    global $wpdb; 
    $tbl_pay = $wpdb->prefix. 'appointment_schedule_booked';

    // Insert payment details into the database
    $wpdb->insert(
        $tbl_pay, 
        array( 
            'asb_user_id' => $user_id, 
            'asb_schedule_id' => $schedule_id, 
            'asb_schedule_date' => $_POST['strip_booking_date'], 
            'asb_schedule_time' => $_POST['strip_booking_time'], 
            'asb_txnid' => $_POST['razorpay_payment_id'], 
            'asb_payment_amount' => $_POST['total'], 
            'asb_payment_status' =>  'successfull', 
            'asb_timestamp' => date('Y-m-d H:i:s'), 
            'asb_customer_details'=> json_encode($_POST), 
            'asb_payment_getway' => 'razorpay', 
        )
    );

    // Check if the database insertion was successful
    if($wpdb->insert_id){
        // Placeholder replacement arrays
        $string_a = array();
        $string_b = array();                

        // ... (rest of the code for placeholder arrays)

        // Email content replacement
        $mail_msg = get_option('app_email_content');
        $email_h = get_option('app_email_h');
        $email_sub = get_option('cafe_email_sub');
        $site = get_bloginfo( 'name' );

        if(!empty($mail_msg)){
            $html = preg_replace($string_a, $string_b, $mail_msg);
        } else {
            // Default email content
            $html = '<div class="mail_template">
                <h1>'. $email_h .'</h1>
                <h4>'. esc_html__('Welcome to '. $site .' hospital.', 'Handly'). ' </h4>
                <h6>'. esc_html__('Invoice #Order', 'Handly'). ' ' . $_POST['razorpay_payment_id']. '<h6>
                <p>'. esc_html__('Your appointment with Dr ABC has been scheduled successfully at '. $_POST['strip_booking_date'] .' on dated '.$_POST['strip_booking_time'] .'', 'Handly').'</p>
                <p>'. esc_html__('The consultation charge '. $currency . ''. $_POST['total'] .'  including '. $_POST['tax_name_n'] .' tax.', 'Handly').'</p>
            </div>';
        }

        // ... (rest of the code for email and SMS)

        // Success response
        $razorpay_success_url = get_option('app_razorpay_success_url').'/?invoice='.base64_encode($wpdb->insert_id);
        $data = array('status' => 'true', 'msg' => 'Success', 'url' => $razorpay_success_url);

    } else {
        // Database insertion failed
        $data = array('status' => 'false', 'msg' => 'Database insertion failed', 'msg1' => $_POST);
    } 
} else {
    // Razorpay payment ID not set
    $data = array('status' => 'false', 'msg' => 'Razorpay payment ID not set');
}

echo json_encode($data);
die();
