<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="hl-hotel-booking-form">
                <form name="hl_booking_form" id="hl_booking_form" method="post">
                    <ul>
                        <li>
                            <div class="t-datepicker">
                              <div class="t-check-in"></div>
                              <div class="t-check-out"></div>
                            </div> 
                        </li> 
                        <li>
                        <select name="Astro_number_of_people" id="Astro_number_of_people">
                            <option value=""> 
                            <?php echo esc_html__('Number of people','astro'); ?></option>
                            <option value="<?php echo esc_attr(1); ?>"> 
                            <?php echo esc_html(1); ?></option>
                            <option value="<?php echo esc_attr(2); ?>"><?php echo esc_html(2); ?></option>
                            <option value="<?php echo esc_attr(3); ?>"><?php echo esc_html(3); ?></option>
                            <option value="<?php echo esc_attr(4); ?>"><?php echo esc_html(4); ?></option>
                            <option value="<?php echo esc_attr(5); ?>"><?php echo esc_html(5); ?></option>
                        </select>
                        </li>
                        <li> 
                        <?php 
                        $args = array(
                            'taxonomy' => 'room-type',
                            'orderby' => 'name',
                            'order'   => 'ASC'
                            );
                        $room_types = get_categories($args);
                        ?>
                        <select name="Astro_room_type" id="Astro_room_type">
                            <option value="">
                             <?php echo esc_html__('Select Room Type','astro'); ?>
                            </option>
                            <?php 
                            if($room_types):
                              foreach($room_types as $rooms):
                            ?>
                            <option value="<?php echo esc_html($rooms->slug); ?>"><?php echo esc_html($rooms->name); ?></option>
                            <?php 
                             endforeach;
                            endif;
                            ?>
                        </select>
                        </li>
                        <li>
                        <button class="hl-btn" type="submit" name="room_find" id="room_find"><?php echo esc_html__('Find','astro'); ?></button>
                        </li>
                    </ul>
                </form>
            </div>
        </div>
    </div>
    <div class="hl-room-wrap" > 
        <div class="row" id="hl_room_filter">
            <?php
            $args = array(  
                'post_type' => 'rooms',
                'post_status' => 'publish',
                'posts_per_page' => -1,
                'order' => 'ASC', 
                'meta_query' => array(
                    'relation' => 'ND',
                    array(
                        'key' => 'hotel_status',
                        'value' => 'open',
                       ), 
                    ),
                );
            $rooms_query = new WP_Query( $args ); 
            if($rooms_query->have_posts()):
                while($rooms_query->have_posts()): $rooms_query->the_post();
                if(has_post_thumbnail(get_the_ID())):
                    $rooms_attachment_url = wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()), 'full');
                endif;
                $room_price_currency = get_post_meta(get_the_ID(),'hotel_currency',true);
                $room_price = get_post_meta(get_the_ID(),'hotel_room_price',true);
            ?>
            <div class="col-xl-4 col-lg-6 col-sm-12">
                <div class="hl-room-box">
                    <?php if(!empty($rooms_attachment_url)): ?>
                        <div class="hl-room-img">
                            <img src="<?php echo esc_url($rooms_attachment_url); ?>" alt="<?php the_title_attribute(); ?>">
                        </div>
                    <?php endif; ?>
                    <div class="hl-room-content">
                        <a href="<?php echo esc_url(get_the_permalink()); ?>" class="hl-room-title"><?php the_title(); ?></a>
                        <p><?php echo substr(get_the_content(),0,100); ?></p>
                        <div class="hl-room-footer">
                            <a href="<?php echo esc_url(get_the_permalink()); ?>" class="hl-btn"><?php echo esc_html__('Book Now','astro'); ?></a>
                            <h4><?php echo esc_html($room_price_currency.$room_price); ?></h4>
                        </div>  
                    </div>
                </div>
            </div>
            <?php 
            endwhile;
            wp_reset_query();
            endif;
            ?>  
        </div>
    </div>
    <!-- Loader Section Start  -->
    <div class="hl-preloader">
        <div class="hl-preloader-box">
        <svg xmlns="http://www.w3.org/2000/svg" width="200px" height="200px" viewBox="0 0 100 100">
            <circle cx="50" cy="50" r="0" fill="none" stroke="#ff8f91" stroke-width="2">
            <animate attributeName="r" repeatCount="indefinite" dur="0.78125s" values="0;35" keyTimes="0;1" keySplines="0 0.2 0.8 1" calcMode="spline" begin="0s"></animate>
            <animate attributeName="opacity" repeatCount="indefinite" dur="0.78125s" values="1;0" keyTimes="0;1" keySplines="0.2 0 0.8 1" calcMode="spline" begin="0s"></animate>
            </circle><circle cx="50" cy="50" r="0" fill="none" stroke="#ff8f91" stroke-width="2">
            <animate attributeName="r" repeatCount="indefinite" dur="0.78125s" values="0;35" keyTimes="0;1" keySplines="0 0.2 0.8 1" calcMode="spline" begin="-0.390625s"></animate>
            <animate attributeName="opacity" repeatCount="indefinite" dur="0.78125s" values="1;0" keyTimes="0;1" keySplines="0.2 0 0.8 1" calcMode="spline" begin="-0.390625s"></animate>
            </circle>
        </svg>
        </div>
    </div>
  <!-- Loader Section End -->
</div>