<?php
/***
 * Astro Custom Post Type For Create Room
 */
$r_labels = array(
    'name' => esc_html__( 'Astro Rooms', 'astro' ),
    'singular_name' => esc_html__( 'Astro Rooms', 'astro' ),
    'menu_name'  => esc_html__( 'Astro Rooms', 'admin menu', 'astro' ),
    'name_admin_bar' => _x( 'Astro Rooms', 'add new on admin bar', 'astro' ),
    'add_new' => _x( 'Add New', 'Rooms', 'astro' ),
    'add_new_item' => esc_html__( 'Add New Room', 'astro' ),
    'new_item'  => esc_html__( 'New Room', 'astro' ),
    'edit_item' => esc_html__( 'Edit Room', 'astro' ),
    'view_item' => esc_html__( 'View Room', 'astro' ),
    'all_items' => esc_html__( 'All Room', 'astro' ),
    'search_items' => esc_html__( 'Search Room', 'astro' ),
    'parent_item_colon'  => esc_html__( 'Parent Room:', 'astro' ),
    'not_found' => esc_html__( 'No Room found.', 'astro' ),
    'not_found_in_trash' => esc_html__( 'No Room found in Trash.', 'astro' )
   );

   $hr_args = array(
    'labels'             => $r_labels,
    'description'        => esc_html__( 'Description.', 'astro' ),
    'public'             => true,
    'publicly_queryable' => true,
    'show_ui'            => true,
    'show_in_menu'       => false,
    'query_var'          => true,
    'rewrite'            => array( 'slug' => 'rooms' ),
    'capability_type'    => 'post',
    'has_archive'        => true,
    'hierarchical'       => false,
    'menu_position'      => null,
    'menu_icon'          => 'dashicons-video-alt3',
    'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt')
   );
  register_post_type( 'rooms', $hr_args );
  /* Add new taxonomy, make it hierarchical (like categories) */
   $rty_labels = array(
      'name'              => esc_html__( 'Room Types', 'astro' ),
      'singular_name'     => esc_html__( 'Room Type', 'astro' ),
      'search_items'      => esc_html__( 'Search Room Types', 'astro' ),
      'all_items'         => esc_html__( 'All Room Types', 'astro' ),
      'parent_item'       => esc_html__( 'Parent Room Type', 'astro' ),
      'parent_item_colon' => esc_html__( 'Parent Room Type:', 'astro' ),
      'edit_item'         => esc_html__( 'Edit Room Type', 'astro' ),
      'update_item'       => esc_html__( 'Update Room Type', 'astro' ),
      'add_new_item'      => esc_html__( 'Add New Room Type', 'astro' ),
      'new_item_name'     => esc_html__( 'New Room Type Name', 'astro' ),
      'menu_name'         => esc_html__( 'Room Type', 'astro' ),
    );

   $rty_args = array(
      'hierarchical'      => true,
      'labels'            => $rty_labels,
      'show_ui'           => true,
      'show_admin_column' => true,
      'query_var'         => true,
      'rewrite'           => array('slug' => 'room-type'),
   );
register_taxonomy('room-type', array('rooms'), $rty_args ); 

/**
 * Hotel Facilities
 */ 
$rty_labels = array(
   'name'              => esc_html__( 'Hotel Facilities', 'astro' ),
   'singular_name'     => esc_html__( 'Hotel Facilities', 'astro' ),
   'search_items'      => esc_html__( 'Search Hotel Facilities', 'astro' ),
   'all_items'         => esc_html__( 'All Hotel Facilities', 'astro' ),
   'parent_item'       => esc_html__( 'Parent Hotel Facilities', 'astro' ),
   'parent_item_colon' => esc_html__( 'Parent Hotel Facilities:', 'astro' ),
   'edit_item'         => esc_html__( 'Edit Hotel Facilities', 'astro' ),
   'update_item'       => esc_html__( 'Update Hotel Facilities', 'astro' ),
   'add_new_item'      => esc_html__( 'Add New Hotel Facilities', 'astro' ),
   'new_item_name'     => esc_html__( 'New Hotel Facilities Name', 'astro' ),
   'menu_name'         => esc_html__( 'Hotel Facilities', 'astro' ),
 );
$rty_args = array(
   'hierarchical'      => true,
   'labels'            => $rty_labels,
   'show_ui'           => true,
   'show_admin_column' => true,
   'query_var'         => true,
   'rewrite'           => array('slug' => 'hotel-facilities'),
); 
register_taxonomy('hotel-facilities', array('rooms'), $rty_args ); 

//Register Meta box
add_action('add_meta_boxes',function (){
    add_meta_box(
         'room-type-mange',     
         'Manage Room Type',     
         'mange_room_type_link',     
         ['rooms'],     
         'side' 
    );
	add_meta_box(
         'hotel-facilities-mange',     
         'Manage Hotel Facilities',     
         'mange_hotel_facilities',     
         ['rooms'],     
         'side'
    );
});

//Meta callback function
function mange_room_type_link($post){
    $cs_meta_val=get_post_meta($post->ID);

    ?>
    <div class="room_type_link">
		<a href="<?php echo get_admin_url();?>edit-tags.php?taxonomy=room-type&post_type=room"><?php echo esc_html('Manage Room Type', 'astro');?></a>
	</div>
    <?php     
}

//Meta callback function
function mange_hotel_facilities($post){
    $cs_meta_val=get_post_meta($post->ID);

    ?>
    <div class="facilities_link">
		<a href="<?php echo get_admin_url();?>edit-tags.php?taxonomy=hotel-facilities&post_type=room"><?php echo esc_html('Manage Hotel Facilities', 'astro');?></a>
	</div>
    <?php     
}
