jQuery(document).ready(function($) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

    /**
	 * Handilu Booking Option Start ajax
	 */
	$(document).on('click','.hl_startbookings',function(){
        var startbooking = $(this).attr('data-startbookings');
        var formdata ='startbooking='+startbooking;
	    formdata += '&action=Astro_connection';
		$(".hl-preloader").show();
		$.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
                var res = jQuery.parseJSON(response);
				if(res.status==1){
    		        toastr.success(res.msg);
					location.reload();
    		    }else{
    		        toastr.error(res.msg); 
    		    }
				$(".hl-preloader").hide();
				
			} 
		});
    });

    /**
	 * Handilu Booking Option Disconnect
	 */
	 $(document).on('click','.hl_disconnectbookings',function(){
        var startbooking = $(this).attr('data-startbookings');
		var formdata ='startbooking='+startbooking;
	    formdata += '&action=Astro_disconnection';
		$(".hl-preloader").show();
		$.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
                var res = jQuery.parseJSON(response);
				console.log(res);
				if(res.status==1){
    		        toastr.success(res.msg);
					location.reload();
    		    }else{
    		        toastr.error(res.msg); 
    		    }
			   $(".hl-preloader").hide();
			} 
		});
    });
	
	
	/** 
	 * Hotel Payment Setting
	 */ 
	$(document).on('submit','#payment_setting',function(e){
		e.preventDefault();
		var curreny_val = $('#curreny_val').val(); 
		var tax_title = $('#tax_title').val(); 
		var text_percent = $('#text_percent').val(); 
		var formdata ='curreny_val='+curreny_val+'&tax_title='+tax_title+'&text_percent='+text_percent;
		$(".hl-preloader").show();
		formdata += '&action=Astro_payment_details_save';
		console.log(formdata);
		$.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });		
	});
	
	/** 
	 * Hotel stripe Payment Detail Save
	 */ 
	$(document).on('submit','#stripe_payment',function(e){
        e.preventDefault();
		var stripe_publishbale_key = $('#stripe_publishbale_key').val(); 
		var stripe_secret_key = $('#stripe_secret_key').val(); 
		var stripe_email = $('#stripe_email').val(); 
		var stripe_success_url = $('#stripe_success_url').val(); 
		var stripe_cancel_url = $('#stripe_cancel_url').val();
		var formdata ='stripe_publishbale_key='+stripe_publishbale_key+'&stripe_secret_key='+stripe_secret_key+'&stripe_email='+stripe_email+'&stripe_success_url='+stripe_success_url+'&stripe_cancel_url='+stripe_cancel_url;
	    formdata += '&action=Astro_hotel_stripe_payment_details_save';
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
    });
	
	/** 
	 * Hotel razorpay Payment Detail Save
	 */ 
	$(document).on('submit','#razorpay_payment',function(e){
        e.preventDefault();
		var razorpay_key = $('#razorpay_key').val(); 
		var razorpay_success_url = $('#razorpay_success_url').val(); 
		var razorpay_cancel_url = $('#razorpay_cancel_url').val();
		var formdata ='razorpay_key='+razorpay_key+'&razorpay_success_url='+razorpay_success_url+'&razorpay_cancel_url='+razorpay_cancel_url;
	    formdata += '&action=Astro_hotel_razorpay_payment_details_save';
		console.log(formdata);
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			 $(".hl-preloader").hide();
			} 
		 });
    });
		
	/** 
	 * Event Payment Setting
	 */ 
	$(document).on('submit','#cafe_payment_setting',function(e){
		e.preventDefault();
		var curreny_val = $('#curreny_val').val(); 
		var tax_title = $('#tax_title').val(); 
		var text_percent = $('#text_percent').val(); 
		var formdata ='curreny_val='+curreny_val+'&tax_title='+tax_title+'&text_percent='+text_percent;
		$(".hl-preloader").show();
		formdata += '&action=Astro_payment_cafe_details_save';
		console.log(formdata);
		$.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });		
	});
	/**
	 * event stripe payment detail save
	 */
	$(document).on('submit','#stripe_cafe_payment',function(e){
        e.preventDefault();
        var stripe_cafe_publishbale_key = $('#stripe_cafe_publishbale_key').val(); 
		var stripe_cafe_secret_key = $('#stripe_cafe_secret_key').val(); 
		var stripe_email = $('#stripe_cafe_email').val(); 
		var stripe_success_url = $('#stripe_cafe_success_url').val(); 
		var stripe_cancel_url = $('#stripe_cafe_cancel_url').val();
		var formdata ='stripe_cafe_publishbale_key='+stripe_cafe_publishbale_key+'&stripe_cafe_secret_key='+stripe_cafe_secret_key+'&stripe_email='+stripe_email+'&stripe_success_url='+stripe_success_url+'&stripe_cancel_url='+stripe_cancel_url;
	    formdata += '&action=Astro_cafe_payment_dateails_save'; 
		
		console.log(formdata);
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
    });
	/** 
	* Event razorpay Payment Detail Save
	 */ 
	$(document).on('submit','#cafe_razorpay_payment',function(e){
        e.preventDefault();
		var cafe_razorpay_key = $('#cafe_razorpay_key').val(); 
		var cafe_razorpay_success_url = $('#cafe_razorpay_success_url').val(); 
		var cafe_razorpay_cancel_url = $('#cafe_razorpay_cancel_url').val();
		var formdata ='cafe_razorpay_key='+cafe_razorpay_key+'&cafe_razorpay_success_url='+cafe_razorpay_success_url+'&cafe_razorpay_cancel_url='+cafe_razorpay_cancel_url;
	    formdata += '&action=Astro_cafe_razorpay_payment_details_save';
		console.log(formdata);
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			 $(".hl-preloader").hide();
			} 
		 });
    });
	
	/**
	 * Event SMS Option Save
	 */
	$(document).on('submit','#cafe_sms_option',function(e){
        e.preventDefault();  
	    var cafe_acsid = $('#cafe_acsid').val(); 
		var cafe_auth_token = $('#cafe_auth_token').val(); 
		var cafe_ac_phone = $('#cafe_ac_phone').val(); 
		var cafe_ac_mssid = $('#cafe_ac_mssid').val();
        var formdata ='cafe_acsid='+cafe_acsid+'&cafe_auth_token='+cafe_auth_token+'&cafe_ac_phone='+cafe_ac_phone+'&cafe_ac_mssid='+cafe_ac_mssid;
	    formdata += '&action=Astro_cafe_sms_option_save'; 
		
		console.log(formdata);
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
	});
	/**
	 * Hotel Email Option Save
	 */
	$(document).on('submit','#cafe_email_option',function(e){
        e.preventDefault();  
	    var cafe_email_h = $('#cafe_email_h').val(); 
		var cafe_email_sub = $('#cafe_email_sub').val(); 
		var cafe_email_content = $('#cafe_email_content').val(); 
        var formdata ='cafe_email_h='+cafe_email_h+'&cafe_email_sub='+cafe_email_sub+'&cafe_email_content='+cafe_email_content;
	    formdata += '&action=Astro_cafe_email_option_save'; 
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
	});
	
	/**
	 * Hotel Color Option Save
	 */
	$(document).on('submit','#cafe_color_option',function(e){
        e.preventDefault();  
	    var primary_color = $('#primary_color').val(); 
		var gc_color = $('#gc_color').val(); 
		var gcc_color = $('#gcc_color').val(); 
        var formdata ='primary_color='+primary_color+'&gc_color='+gc_color+'&gcc_color='+gcc_color;
	    formdata += '&action=Astro_cafe_color_option_save'; 
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
	});
	
	
	
	

	

	 /**
	  * Event Custom Option Setting
	  */
	$(document).on('submit','#cafe_custom_option',function(e){
        e.preventDefault();
        var confirmation_charge = $('#cafe_confirmation_charge').val(); 
		var display_currency = $('#cafe_display_currency').val(); 
		var booking_form_heading = $('#cafe_booking_form_heading').val(); 
		var booking_review_heading = $('#cafe_booking_review_heading').val(); 
		var payment_form_heading = $('#cafe_payment_form_heading').val(); 
		var booking_invoice_heading = $('#cafe_booking_invoice_heading').val();
        var cafe_booking_calendar_heading = $('#cafe_booking_calendar_heading').val();
        var formdata ='confirmation_charge='+confirmation_charge+'&display_currency='+display_currency+'&booking_form_heading='+booking_form_heading+'&booking_review_heading='+booking_review_heading+'&payment_form_heading='+payment_form_heading+'&booking_invoice_heading='+booking_invoice_heading+'&cafe_booking_calendar_heading='+cafe_booking_calendar_heading;  
	    formdata += '&action=Astro_cafe_custom_option_save'; 
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
	});

	/**
	 * Hotel Custom Option
	 */
	$(document).on('submit','#hotel_custom_option',function(e){
        e.preventDefault();  
	    var confirmation_charge = $('#hotel_confirmation_charge').val(); 
		var display_currency = $('#hotel_display_currency').val(); 
		var booking_form_heading = $('#hotel_booking_form_heading').val(); 
		var booking_review_heading = $('#hotel_booking_review_heading').val(); 
		var payment_form_heading = $('#hotel_payment_form_heading').val(); 
		var booking_invoice_heading = $('#hotel_booking_invoice_heading').val();
        var formdata ='confirmation_charge='+confirmation_charge+'&display_currency='+display_currency+'&booking_form_heading='+booking_form_heading+'&booking_review_heading='+booking_review_heading+'&payment_form_heading='+payment_form_heading+'&booking_invoice_heading='+booking_invoice_heading;
	    formdata += '&action=Astro_hotel_custom_option_save'; 
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
	});
	
	/**
	 * Hotel SMS Option Save
	 */
	$(document).on('submit','#hotel_sms_option',function(e){
        e.preventDefault();  
	    var acsid = $('#acsid').val(); 
		var auth_token = $('#auth_token').val(); 
		var ac_phone = $('#ac_phone').val(); 
		var ac_mssid = $('#ac_mssid').val();
        var formdata ='acsid='+acsid+'&auth_token='+auth_token+'&ac_phone='+ac_phone+'&ac_mssid='+ac_mssid;
	    formdata += '&action=Astro_hotel_sms_option_save'; 
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
	});
	
	/**
	 * Hotel Email Option Save
	 */
	$(document).on('submit','#hotel_email_option',function(e){
        e.preventDefault();  
	    var email_h = $('#email_h').val(); 
		var email_sub = $('#email_sub').val(); 
		var email_content = $('#email_content').val(); 
        var formdata ='email_h='+email_h+'&email_sub='+email_sub+'&email_content='+email_content;
	    formdata += '&action=Astro_hotel_email_option_save'; 
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
	});
	
	/**
	 * Hotel Color Option Save
	 */
	$(document).on('submit','#hotel_color_option',function(e){
        e.preventDefault();  
	    var primary_color = $('#primary_color').val(); 
		var gc_color = $('#gc_color').val(); 
		var gcc_color = $('#gcc_color').val(); 
        var formdata ='primary_color='+primary_color+'&gc_color='+gc_color+'&gcc_color='+gcc_color;
	    formdata += '&action=Astro_hotel_color_option_save'; 
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
	});
	
	
	
	/** 
	 * Event Payment Setting
	 */ 
	$(document).on('submit','#app_payment_setting',function(e){
		e.preventDefault();
		var app_curreny_val = $('#app_curreny_val').val(); 
		var app_tax_title = $('#app_tax_title').val(); 
		var app_text_percent = $('#app_text_percent').val(); 
		var formdata ='app_curreny_val='+app_curreny_val+'&app_tax_title='+app_tax_title+'&app_text_percent='+app_text_percent;
		$(".hl-preloader").show();
		formdata += '&action=Astro_app_payment_save';
		console.log(formdata);
		$.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });		
	});
	
	/** 
	 * Event Payment Setting
	 */ 
	$(document).on('submit','#app_razorpay_payment',function(e){
		e.preventDefault();
		var app_razorpay_key = $('#app_razorpay_key').val(); 
		var app_razorpay_success_url = $('#app_razorpay_success_url').val(); 
		var app_razorpay_cancel_url = $('#app_razorpay_cancel_url').val(); 
		var formdata ='app_razorpay_key='+app_razorpay_key+'&app_razorpay_success_url='+app_razorpay_success_url+'&app_razorpay_cancel_url='+app_razorpay_cancel_url;
		$(".hl-preloader").show();
		formdata += '&action=Astro_app_razorpay_save';
		console.log(formdata);
		$.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });		
	});
	
    /**
	 * Appoint Booking Option
	 */
	$(document).on('submit','#stripe_appointment_payment',function(e){
		e.preventDefault();  
        var stripe_publishbale_key = $('#stripe_publishbale_key').val(); 
		var stripe_secret_key = $('#stripe_secret_key').val(); 
		var stripe_email = $('#stripe_email').val(); 
		var stripe_success_url = $('#stripe_success_url').val(); 
		var stripe_cancel_url = $('#stripe_cancel_url').val();
		var formdata ='stripe_publishbale_key='+stripe_publishbale_key+'&stripe_secret_key='+stripe_secret_key+'&stripe_email='+stripe_email+'&stripe_success_url='+stripe_success_url+'&stripe_cancel_url='+stripe_cancel_url;
	    formdata += '&action=Astro_appointment_paymentdetail_save';   
		$(".hl-preloader").show(); 
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });

	});

    /**
	 * Appoint Booking Custom Option
	 */
	$(document).on('submit','#appointment_custom_option',function(e){
		e.preventDefault();  
        var confirmation_charge = $('#appointment_confirmation_charge').val(); 
		var display_currency = $('#appointment_display_currency').val(); 
		var booking_form_heading = $('#appointment_booking_form_heading').val(); 
		var booking_review_heading = $('#appointment_booking_review_heading').val(); 
		var payment_form_heading = $('#appointment_payment_form_heading').val();
		var booking_invoice_heading = $('#appointment_booking_invoice_heading').val(); 
		var formdata ='confirmation_charge='+confirmation_charge+'&display_currency='+display_currency+'&booking_form_heading='+booking_form_heading+'&booking_review_heading='+booking_review_heading+'&payment_form_heading='+payment_form_heading+'&booking_invoice_heading='+booking_invoice_heading;
	    formdata += '&action=Astro_appointment_custom_option_save';   
		$(".hl-preloader").show(); 
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 }); 
	});
	
	/** 
	 * Event Payment Setting
	 */ 
	$(document).on('submit','#app_sms_option',function(e){
		e.preventDefault();
		var app_acsid = $('#app_acsid').val(); 
		var app_auth_token = $('#app_auth_token').val(); 
		var app_ac_phone = $('#app_ac_phone').val(); 
		var app_ac_mssid = $('#app_ac_mssid').val(); 
		var app_ac_msg = $('#app_ac_msg').val(); 
		var formdata ='app_acsid='+app_acsid+'&app_auth_token='+app_auth_token+'&app_ac_phone='+app_ac_phone+'&app_ac_mssid='+app_ac_mssid+'&app_ac_msg='+app_ac_msg;
		$(".hl-preloader").show();
		formdata += '&action=Astro_app_sms_save';
		$.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });		
	});
	
	/**
	 * Hotel Color Option Save
	 */
	$(document).on('submit','#app_color_option',function(e){
        e.preventDefault();  
	    var primary_color = $('#primary_color').val(); 
		var gc_color = $('#gc_color').val(); 
		var gcc_color = $('#gcc_color').val(); 
        var formdata ='primary_color='+primary_color+'&gc_color='+gc_color+'&gcc_color='+gcc_color;
	    formdata += '&action=Astro_app_color_option_save'; 
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
	});
	
	/**
	 * Hotel Color Option Save
	 */
	$(document).on('submit','#app_email_option',function(e){
        e.preventDefault();  
	    var app_email_h = $('#app_email_h').val(); 
		var app_email_sub = $('#app_email_sub').val(); 
		var app_email_content = $('#app_email_content').val(); 
        var formdata ='app_email_h='+app_email_h+'&app_email_sub='+app_email_sub+'&app_email_content='+app_email_content;
	    formdata += '&action=Astro_app_email_option_save'; 
		$(".hl-preloader").show();
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			} 
		 });
	});

	/**
	 * Appointment Schedule Date picker
	 */
	 if ($.fn.datepicker) {
		var current = new Date();
        $('#appointment_schedule_datepicker').datepicker({
			format: 'yyyy-mm-dd', 
			startDate: current,
			pickTime:false,
			autoclose: true,
		});   
		
	/**
	 * Event Date Disble 
	 */
		$('#cafe_disble_datepicker').datepicker({
			format: 'yyyy-mm-dd', 
			startDate: current,
			pickTime:false,
			autoclose: true,
		}); 
	/**
	 * Appointment Time picker
	 */ 
	$('.hl_schedule_times_picker').datetimepicker({
		pickDate: false,
		minuteStep: 15,
		pickerPosition: 'bottom-right',
		format: 'HH:ii p',
		autoclose: true,
		showMeridian: true,
		startView: 1,
		maxView: 1
     }); 
	} 
	/** 
	 * Appointment Time Schedule Mange
	 */
	$(document).on('click','#hl_add_schedule',function(e){
       e.preventDefault();
	   var fieldHTML = '<div><input type="text" name="schedule_times[]" class="hl_schedule_times_picker" value=""/><a href="javascript:void(0);" class="remove_button">Remove</a></div>';
       $('#schedule_time_pickers').append(fieldHTML);
	   $('.hl_schedule_times_picker').datetimepicker({
		pickDate: false,
		minuteStep: 15,
		pickerPosition: 'bottom-right',
		format: 'HH:ii p',
		autoclose: true,
		showMeridian: true,
		startView: 1,
		maxView: 1
	   }); 
	});	
	$(document).on('click', '.remove_button', function(e){
        e.preventDefault();
        $(this).parent('div').remove(); 
        x--; 
    }); 
	
	/**
	 * Astro QR Code 
	 */
	$(document).on('submit','#hl_qr_code_form',function(e){
		e.preventDefault();
        var hl_qrinput_title = $('#hl_qrinput_title').val(); 
        var hl_qrinput_number = $('#hl_qrinput_number').val(); 
		var hl_qrtext_url = $('#hl_qrtext_url').val(); 
		var formdata ='hl_qrinput_title='+hl_qrinput_title+'&hl_qrinput_number='+hl_qrinput_number+'&hl_qrtext_url='+hl_qrtext_url;
	    formdata += '&action=Astro_qr_code_save';    
		$(".hl-preloader").show(); 
        $.ajax({
			type: 'post',
			url: Astro_ajax_path.url, 
			data: formdata,
			success: function(response){
              toastr.success(response);
			  $(".hl-preloader").hide();
			  location.reload(true);
			} 
		 }); 
    });
   // Qr Code PrintArea  
	$("#hl_qr_code_print").on('click',function(){ 
		$("#hl_qr_code_section").printArea();
	}); 
	
	// xls export 
	$("#xlsexport").click(function(){
		$(".table-view-list").table2excel({
			// exclude CSS class
			name: "Worksheet Name",
			filename: "Bookinglist", //do not include extension
			fileext: ".xls", // file extension
			exclude_links: true,
			exclude_inputs: true,
			columns : [2,1]
		}); 
	});
	
	$("#csvexport").click(function(){
		$("table").table2csv({
			separator: ',',
			  newline: '\n',
			  quoteFields: true,
			  excludeColumns: '',
			  excludeRows: ''
			  //trimContent: true // Trims the content of individual <th>, <td> tags of whitespaces. 
			});
	});
	
});

     
/** 
 * Hotel Gallery Image upload
 */
function add_image(obj) {
	var parent=jQuery(obj).parent().parent('div.field_row');
	var inputField = jQuery(parent).find("input.meta_image_url");
    tb_show('', 'media-upload.php?TB_iframe=true');
    window.send_to_editor = function(html) {
		var url = jQuery(html).find('img').attr('src');
		inputField.val(url);
		jQuery(parent)
		.find("div.image_wrap")
		.html('<img src="'+url+'" height="48" width="48" />');
        tb_remove();
	};
    return false;  
}
function remove_field(obj) {
	var parent=jQuery(obj).parent().parent();
	parent.remove();
}
function add_field_row() {
	var row = jQuery('#master-row').html();
	jQuery(row).appendTo('#field_wrap');
}

function download_csv(csv, filename) {
    var csvFile;
    var downloadLink;

    // CSV FILE
    csvFile = new Blob([csv], {type: "text/csv"});

    // Download link
    downloadLink = document.createElement("a");

    // File name
    downloadLink.download = filename;

    // We have to create a link to the file
    downloadLink.href = window.URL.createObjectURL(csvFile);

    // Make sure that the link is not displayed
    downloadLink.style.display = "none";

    // Add the link to your DOM
    document.body.appendChild(downloadLink);

    // Lanzamos
    downloadLink.click();
}
