<?php
/**
 * Event Shortcode Listing
 */ 
if(!function_exists('astro_event_listing_shortcode')):
    add_shortcode('event_listing_shortcode','astro_event_listing_shortcode');
    
    function astro_event_listing_shortcode($atts,$content){
        
        extract( shortcode_atts(array(
                'listnumber' =>'9',  
                'liststyle' => '',
                'pagination' => '',
                'filter_city' => '',
                'filter_country' => '',
                'cols' => 2
                ), $atts)
               );
       
        $result = '';
        if($pagination){
	       $pagination = 'yes';  
    	}else{
           $pagination = 'no';   
	    }
		
		$filter = !empty($filter_city) ? "city=$filter_city " : '';
		$filter .= !empty($filter_country) ? "country=$filter_country" : '';
	    
        switch ($liststyle) {
            
        case 'list':    
            $result .= do_shortcode("[event-list style='list' show=$listnumber pagination=$pagination $filter]");
        break;
        
        case 'minimal': 
            $result .= do_shortcode("[event-list style='minimal' show=$listnumber pagination=$pagination $filter]");
        break;
        
        case 'native': 
           $result .= do_shortcode("[event-list style='native' show=$listnumber pagination=$pagination $filter]");
        break;
        
        case 'grid': 
           $result .= do_shortcode('[event-list org-filter=yes style=grid column='.$cols.' '.$filter.']');
        break;
        
        case 'vertical': 
           $result .= do_shortcode("[event-list style='timeline' timeline-mode='vertical' $filter]");
        break;
        
        case 'horizontal': 
           $result .= do_shortcode("[event-list style='timeline' timeline-mode='horizontal' $filter]");
        break;
        
        case 'carousalgrid': 
           $result .= do_shortcode("[event-list style='grid' pagination='carousal' carousal-dots='yes' carousal-nav='yes' column=3 $filter]");
        break;
        
        case 'carousallist': 
           $result .= do_shortcode(" [event-list style='list' pagination='carousal' carousal-dots='yes' carousal-nav='yes' carousal-id='UI123' $filter]");
        break;
        
        case 'carousalminimal': 
           $result .= do_shortcode("[event-list style='minimal' pagination='carousal' carousal-dots='yes' carousal-nav='no' carousal-id='UI124' $filter]");
        break;
        
        case 'carousalnative': 
           $result .= do_shortcode("[event-list style='native' pagination='carousal' carousal-dots='yes' carousal-nav='no' carousal-id='UI125' $filter]");
        break;
        
        default:
            $result .= do_shortcode("[event-list column=3 show=$listnumber $filter]");
       
        }
       
        return $result;
    }
    
endif;


/**
 * Event Add To Cart Section
 */
if(!function_exists('astro_event_addtocard')):
    
    add_shortcode('event_addtocart_shortcode','astro_event_addtocard');
    function astro_event_addtocard($atts,$content){
        
        extract(shortcode_atts(array(
                  'listnumber' =>'9',  
                  'liststyle' => '',
                  'pagination' => ''
                  ), $atts)
               );
       
        $result = '';
        
        $result .= do_shortcode("[event-add-cart-section event=10408]");
        
        return $result;  
    }
    
endif;

/**
* Event Calender
*/
add_shortcode('event_calender_shortcode','event_calender_shortcode_view');
function event_calender_shortcode_view($atts,$content){

	return do_shortcode("[event-calendar]");
	
}

/**
* Event Calender
*/
add_shortcode('event_citylist','event_citylist_view');
function event_citylist_view($atts,$content){

	return do_shortcode("[event-city-list]");
	
}

/**
* Event Speakers
*/
add_shortcode('event_speakers','event_speakers_view');
function event_speakers_view($atts,$content){
	
	$filter = !empty($atts['event_id']) ? ' event='.$atts['event_id'].'' : '';
	
	return do_shortcode('[event-speaker-list'.$filter.']');
	
}