<?php
if (!class_exists( 'WP_List_Table' ) ) {
	require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}
/**
 * Astro Rooms Data Table
 */
class Astro_Rooms_list_Table extends WP_List_Table {

	public function __construct() {
		// Set parent defaults.
		parent::__construct( array(
			'singular' => 'user',     // Singular name of the listed records.
			'plural'   => 'users',    // Plural name of the listed records.
			'ajax'     => true,       // Does this table support ajax?
		) );
	}

	public function display_data() {
		
		global $wpdb;
		$room_data = array();
		$args = array(
			'post_type' =>'rooms',
			'posts_per_page' => -1,
			'post_status' =>'publish',
		   );
	    $rooms_query = new WP_Query($args);
        if($rooms_query->have_posts() ) :
		    while($rooms_query->have_posts() ) : $rooms_query->the_post();
            $terms_slug_str = '';
			$terms = get_the_terms(get_the_ID(), 'room-type');
			if ($terms && ! is_wp_error($terms)) :
				$tslugs_arr = array();
				foreach ($terms as $term) {
					$tslugs_arr[] = $term->name;
				}
				$terms_slug_str = join( " ", $tslugs_arr);
			endif;

			$room_title = '<a href="'.esc_url(get_the_permalink(get_the_ID())).'">'.get_the_title().'</a>';
			$delete_query_args = array(
				'page'   => 'hotel_rooms',
				'action' => 'delete',
				'user'  => get_the_ID(),
			   );
			$room_edite = '<a href="'.esc_url(get_edit_post_link(get_the_ID())).'" class="hl-edit">'.esc_html__('Edit','astro').'</a> <a href="'.esc_url( wp_nonce_url( add_query_arg( $delete_query_args, 'admin.php' ), 'deleteuser_'.get_the_ID()) ).'" class="hl-delete">'.esc_html__('Delete','astro').'</a>';

            $price_currency = get_post_meta(get_the_ID(),'hotel_currency',true);
            $room_price = get_post_meta(get_the_ID(),'hotel_room_price',true);
			$room_capacity = get_post_meta(get_the_ID(),'hotel_room_capacity',true);

            $room_status = get_post_meta(get_the_ID(),'hotel_status',true);
			if($room_status == 'open'):
               $room_status = '<span class="hl-status-active">'.get_post_meta(get_the_ID(),'hotel_status',true).'</span>'; 
            else:
			   $room_status = '<span class="hl-status-deactivate">'.get_post_meta(get_the_ID(),'hotel_status',true).'</span>'; 
			endif;
			$room_data[] = array('ID' => get_the_ID(), 
							'room_name' => $room_title, 
							'room_type' => $terms_slug_str,
							'room_price' => $price_currency.''.$room_price,
							'room_capacity' => $room_capacity,
							'status' => $room_status,
							'actions' => $room_edite, 
							);

		    endwhile;
		endif;
        return $room_data;
	}

	public function no_items() {
	  _e( 'No users avaliable.', 'users' );
	}

	public function get_columns() {
		$columns = array(
			'cb' => '<input type="checkbox" />', 
			'room_name' => esc_html__( 'Room Name','astro'),
			'room_type' => esc_html__( 'Room Type','astro'),
			'room_price' => esc_html__( 'Room Price','astro' ),
			'room_capacity' => esc_html__( 'Room Capacity','astro'),
			'status' => esc_html__( 'Status', 'astro'),
			'actions' => esc_html__( 'Actions', 'astro'),
		    );
        return $columns;
	}

	protected function get_sortable_columns() {
		$sortable_columns = array(
			'room_name'    => array( 'room_name', false ),
			'room_price'   => array( 'room_price', false )
		);

		return $sortable_columns;
	}

	protected function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'room_name':
				return $item[ $column_name ];
				break;
			case 'room_type':
				return $item[ $column_name ];
				break;
			case 'room_price':
				return $item[ $column_name ];
				break;
			case 'room_capacity':
				return $item[ $column_name ];
				break;
			case 'status':
				return $item[ $column_name ];
				break;
			case 'actions':
				return $item[ $column_name ];
			    break;
			
        }
		
	}

	protected function column_cb( $item ) {
		return sprintf(
			'<input type="checkbox" name="%1$s[]" value="%2$s" />',
			$this->_args['singular'],  // Let's simply repurpose the table's singular label ("user").
			$item['ID']                // The value of the checkbox should be the record's ID.
		);
	}

	protected function column_title( $item ) {
		$page = wp_unslash( $_REQUEST['page'] ); // WPCS: Input var ok.

		// Build edit row action.
		$edit_query_args = array(
			'page'   => $page,
			'action' => 'edit',
			'user'  => $item['ID'],
		);

		$actions['edit'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $edit_query_args, 'admin.php' ), 'edituser_' . $item['ID'] ) ),
			_x( 'Edit', 'row action','astro')
		);

		// Build delete row action.
		$delete_query_args = array(
			'page'   => $page,
			'action' => 'delete',
			'user'  => $item['ID'],
		);

		$actions['delete'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $delete_query_args, 'admin.php' ), 'deleteuser_' . $item['ID'] ) ),
			_x( 'Delete', 'row action','astro')
		);

		// Return the room_name contents.
		return sprintf( '%1$s %2$s',
			$item['room_name'],
			$this->row_actions( $actions )
		);
	}

	protected function get_bulk_actions() {
		$actions = array(
			'delete' => _x( 'Delete', 'bulk action', 'astro' ),
		);

		return $actions;
	}
 
    protected function process_bulk_action() {
		// Detect when a bulk action is being triggered.
		//print_r($_GET);
		if ( 'delete' === $this->current_action() ) {
			if(is_array($_GET['user'])){
				foreach ($_GET['user'] as $value) {
					wp_delete_post($value);
				}
		    }else{
				wp_delete_post($_GET['user']);
			}
		}

		// Edit when a bulk action is being triggered.
		if ( 'edit' === $this->current_action() ) {
			$this->single_row_edit();
			
		}
	} 

	function single_row_edit() {
		require dirname( __FILE__ ) . '/user-edit.php';
		wp_die();
	}

	function prepare_items() {
		global $wpdb; //This is used only if making any database queries

		/*
		 * First, lets decide how many records per page to show
		 */
		
		$per_page = 20;
        $columns  = $this->get_columns();
		$hidden   = array();
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array( $columns, $hidden, $sortable );

		$this->process_bulk_action();

		$data = $this->display_data();

		usort( $data, array( $this, 'usort_reorder' ) );

		$current_page = $this->get_pagenum();

		$total_items = count( $data );

		$data = array_slice( $data, ( ( $current_page - 1 ) * $per_page ), $per_page );

		$this->items = $data;

		$this->set_pagination_args( array(
			'total_items' => $total_items,                     // WE have to calculate the total number of items.
			'per_page'    => $per_page,                        // WE have to determine how many items to show on a page.
			'total_pages' => ceil( $total_items / $per_page ), // WE have to calculate the total number of pages.
		) );
	}

	protected function usort_reorder( $a, $b ) {
		// If no sort, default to title.
		$orderby = ! empty( $_REQUEST['orderby'] ) ? wp_unslash( $_REQUEST['orderby'] ) : 'room_name'; 

		// If no order, default to asc.
		$order = ! empty( $_REQUEST['order'] ) ? wp_unslash( $_REQUEST['order'] ) : 'asc'; 

		// Determine sort order.
		$result = strcmp( $a[ $orderby ], $b[ $orderby ] );

		return ( 'asc' === $order ) ? $result : - $result;
	}
}

/**
 * Astro Booking List 
 */
class Astro_booking_Table extends WP_List_Table {
  
	public function __construct() {
		// Set parent defaults.
		parent::__construct( array(
			'singular' => 'user',     // Singular name of the listed records.
			'plural'   => 'users',    // Plural name of the listed records.
			'ajax'     => false,       // Does this table support ajax?
		) );
	}

	public function display_data() {
		global $wpdb;
		$booking_data = array();
		$pmt_tbl = $wpdb->prefix . 'hotel_room_booked';

		if(isset($_GET['s']) && $_GET['s'] != ''){
		    $allubooked = $_GET['s'];
		    $books_ids = array();
		  //  foreach($allubooked as $booked){
		  //      $books_ids[] = $booked->b_id;
		  //  }  
		  //  $str_ids = implode(',', $books_ids);
		    $booking_query = $wpdb->get_results("SELECT * FROM $pmt_tbl WHERE b_start_date ='$allubooked'");
		}else{
		    $booking_query = $wpdb->get_results("SELECT * FROM $pmt_tbl ORDER BY b_id ASC");
		}
        
		if($booking_query) {  
			foreach ($booking_query as $booking) {
				$customer_details = json_decode($booking->b_customer_details);
				$first_name = '';
				if(!empty($customer_details->first_name)):
		        $first_name = $customer_details->first_name;
                endif;
				$last_name = '';
				if(!empty($customer_details->last_name)):
				$last_name = $customer_details->last_name;
				endif;
				$eamil = '';
				if(!empty($customer_details->eamil)):
				$eamil = $customer_details->eamil;
				endif;
				$contact_number = '';
				if(!empty($customer_details->contact_number)):
				$contact_number = $customer_details->contact_number;
				endif;
				$address = '';
                if(!empty($customer_details->address)):
				$address = $customer_details->address;
				endif;
				$price_currency = get_post_meta($booking->b_room_id,'hotel_currency',true);
				$room_name = '<a href="'.esc_url(get_edit_post_link($booking->b_room_id)).'" class="hl-edit">'.get_the_title($booking->b_room_id).'</a>';
				$booking_data[] = array('ID' => $booking->b_id, 
				                'customer_name' => $first_name.' '.$last_name, 
								'email' => $eamil,
								'contact_number' => $contact_number,
								'address' => $address,
								'txn_id' => $booking->b_txnid,
								'payment_amount' => $price_currency.''.$booking->b_payment_amount,
								'payment_status' => $booking->b_payment_status, 
								'room_name' => $room_name,
								'createdtime' => date('d-m-Y',strtotime($booking->b_timestamp)),
								'check_in_date' => date('d-m-Y',strtotime($booking->b_start_date)),
								'check_out_date' => date('d-m-Y',strtotime($booking->b_end_date)),
								'adults' => $booking->b_adults ,
								'children' => $booking->b_children , 
								);

			}
		}
		return $booking_data;
	}

	public function no_items() {
	  esc_html_e( 'No Booking Avaliable.', 'astro');
	}

	public function get_columns() {
		$columns = array(
			'cb' => '<input type="checkbox" />',   
			// Render a checkbox instead of text.
			'customer_name'    => esc_html__( 'Customer', 'astro'),
			'email' => esc_html__( 'Email', 'astro'),
			'contact_number' => esc_html__('Contact Number', 'astro'),
			'address' => esc_html__('Address', 'astro'), 
			'txn_id' => esc_html__( 'Transaction Id', 'astro'),
			'payment_amount' => esc_html__( 'Amount', 'astro'),
			'payment_status' => esc_html__( 'Status', 'astro' ),
			'room_name' => esc_html__('Room Name', 'astro'),
			'createdtime' => esc_html__( 'Booking Date', 'astro'),
			'check_in_date' => esc_html__( 'Check In Date', 'astro'),
			'check_out_date' => esc_html__( 'Check Out Date', 'astro'),
			'adults' => esc_html__('Adults', 'astro'),
			'children' => esc_html__('Children', 'astro'),
			); 
        return $columns;
	}

	protected function get_sortable_columns() {
		$sortable_columns = array(
			'payment_amount'    => array( 'payment_amount', false ),
			'room_name'   => array( 'room_name', false ),
			'createdtime'   => array( 'createdtime', false ),
			'check_in_date'   => array( 'check_in_date', false ),
			'check_out_date'   => array( 'check_out_date', false ),
		  );
        return $sortable_columns;
	}

	protected function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'customer_name':
				return $item[ $column_name ];
			case 'email':
				return $item[ $column_name ];
			case 'contact_number':
				return $item[ $column_name ];
			case 'address':
				return $item[ $column_name ];
			case 'txn_id':
				return $item[ $column_name ];
			case 'payment_amount':
				return $item[ $column_name ];
			case 'payment_status':
				return $item[ $column_name ];			
			case 'room_name':
				return $item[ $column_name ];
			case 'createdtime':
				return $item[ $column_name ];
			case 'check_in_date':
				return $item[ $column_name ];
			case 'check_out_date':
				return $item[ $column_name ];	
			case 'adults':
				return $item[ $column_name ];	
			case 'children':
				return $item[ $column_name ];			
		}
	}

	protected function column_cb( $item ) {
		return sprintf(
			'<input type="checkbox" name="%1$s[]" value="%2$s" />',
			$this->_args['singular'],  // Let's simply repurpose the table's singular label ("user").
			$item['ID']                // The value of the checkbox should be the record's ID.
		);
	}

	protected function column_title( $item ) {
		$page = wp_unslash( $_REQUEST['page'] ); // WPCS: Input var ok.

		// Build edit row action.
		$edit_query_args = array(
			'page'   => $page,
			'action' => 'edit',
			'user'  => $item['ID'],
		);

		$actions['edit'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $edit_query_args, 'admin.php' ), 'edituser_' . $item['ID'] ) ),
			_x( 'Edit', 'row action','astro')
		);

		// Build delete row action.
		$delete_query_args = array(
			'page'   => $page,
			'action' => 'delete',
			'user'  => $item['ID'],
		);

		$actions['delete'] = sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( wp_nonce_url( add_query_arg( $delete_query_args, 'admin.php' ), 'deleteuser_' . $item['ID'] ) ),
			_x( 'Delete', 'row action','astro')
		);

		// Return the title contents.
		return sprintf( '%1$s %2$s',
			$item['customer_name'],
			$this->row_actions( $actions )
		);
		
	
	}

	protected function get_bulk_actions() {
		$actions = array(
			'delete' => _x( 'Delete', 'bulk action', 'astro' ),
		);

		return $actions;
	}


	protected function process_bulk_action() {
		// Detect when a bulk action is being triggered.
		global $wpdb;
		$pmt_tbl = $wpdb->prefix . 'hotel_room_booked';
		if ( 'delete' === $this->current_action() ) {
			foreach ($_GET['user'] as $value) {
				$wpdb->delete( $pmt_tbl, array( 'b_id' => $value ), array( '%d' ) );
			}
		}

		// Edit when a bulk action is being triggered.
		if ( 'edit' === $this->current_action() ) {
			$this->single_row_edit();
			wp_die( 'Items edited (or they would be if we had items to edit)!' );
		}
	}

	function single_row_edit() {
		require dirname( __FILE__ ) . '/user-edit.php';
		wp_die();
	}

	function prepare_items() {
		global $wpdb; //This is used only if making any database queries

		/*
		 * First, lets decide how many records per page to show
		 */
		
		$per_page = 20;
        $columns  = $this->get_columns();
		$hidden   = array();
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array( $columns, $hidden, $sortable );

		$this->process_bulk_action();

		$data = $this->display_data();

		usort( $data, array( $this, 'usort_reorder' ) );

		$current_page = $this->get_pagenum();

		$total_items = count( $data );

		$data = array_slice( $data, ( ( $current_page - 1 ) * $per_page ), $per_page );

		$this->items = $data;

		$this->set_pagination_args( array(
			'total_items' => $total_items,                     // WE have to calculate the total number of items.
			'per_page'    => $per_page,                        // WE have to determine how many items to show on a page.
			'total_pages' => ceil( $total_items / $per_page ), // WE have to calculate the total number of pages.
		) );
	}

	protected function usort_reorder( $a, $b ) {
		// If no sort, default to title.
		$orderby = ! empty( $_REQUEST['orderby'] ) ? wp_unslash( $_REQUEST['orderby'] ) : 'customer_name'; 

		// If no order, default to asc.
		$order = ! empty( $_REQUEST['order'] ) ? wp_unslash( $_REQUEST['order'] ) : 'asc'; 

		// Determine sort order.
		$result = strcmp( $a[ $orderby ], $b[ $orderby ] );

		return ( 'asc' === $order ) ? $result : - $result;
	}
}