<div class="hl-main-wraper">
   <div class="container-fluid">
        <div class="hl-card-body">
            <h1 class="hl-heading-title"><?php echo esc_html__('QR Code','astro'); ?></h1>
            <div class="row">
                <div class="col-lg-6">
                    <div class="hl-qr-wrap">
                        <form id="hl_qr_code_form" action="" method="post">
                            <ul>
                                <li>
                                <label for="hl_qrinput_title"><?php echo esc_html__('Title','astro');?></label>
                                <input type="text" id="hl_qrinput_title" name="hl_qrinput_title" value="<?php echo esc_attr(get_option('hl_qr_code_heading')); ?>">
                                </li>
                                <li>
                                <label for="hl_qrinput_number"><?php echo esc_html__('Mobile Number','astro'); ?></label>
                                <input type="number" id="hl_qrinput_number" name="hl_qrinput_number" value="<?php echo esc_attr(get_option('hl_qr_contact_number')); ?>">  
                                </li>
                                <li>
                                <label for="hl_qrtext_url"><?php echo esc_html__('QR Code','astro'); ?></label>
                                 <input id="hl_qrtext_url" name="hl_qrtext_url" type="text" value="<?php echo esc_attr(get_option('hl_qr_custom_url')); ?>"/>
                                </li>
                                <li>
                                 <button class="hl-btn" type="submit" name="hl_qr_code_form"><?php echo esc_html__('Submit','astro'); ?></button>
                                </li>
                            </ul>
                        <form>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="hl-qr-box">
                        <?php 
                        $qr_code_option_url = get_option('hl_qr_custom_url');
                        if(!empty($qr_code_option_url)):
                        ?>
                        <div id="hl_qr_code_section">
                        <ul id="printableArea">
                            <li class="hl-qr-title"><?php echo esc_html(get_option('hl_qr_code_heading')); ?></li>
                            <li class="hl-qr-number"><?php echo esc_html(get_option('hl_qr_contact_number')); ?></li> 
                            <li>
                            <img id='barcode' src="<?php echo esc_url('https://api.qrserver.com/v1/create-qr-code/?data='.$qr_code_option_url.'&amp;size=300x300'); ?>" 
                                alt="<?php echo esc_attr__('Astro QR Code','astro'); ?>" 
                                title="<?php echo esc_attr(get_option('hl_qr_code_heading')); ?>" 
                                />
                            </li>
                        </ul>
                        </div>
                        <button class="hl-btn hl-qr-print-btn" id="hl_qr_code_print" type="button"><?php echo esc_html__('Print','astro'); ?></button>
                       <?php 
                        else:
                         echo "<h3>".esc_html__('Please Create QR Code')."</h3>";
                        endif;
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Loader Section Start  -->
<div class="hl-preloader">
<div class="hl-preloader-box">
<svg xmlns="http://www.w3.org/2000/svg" width="200px" height="200px" viewBox="0 0 100 100">
    <circle cx="50" cy="50" r="0" fill="none" stroke="#ff8f91" stroke-width="2">
    <animate attributeName="r" repeatCount="indefinite" dur="0.78125s" values="0;35" keyTimes="0;1" keySplines="0 0.2 0.8 1" calcMode="spline" begin="0s"></animate>
    <animate attributeName="opacity" repeatCount="indefinite" dur="0.78125s" values="1;0" keyTimes="0;1" keySplines="0.2 0 0.8 1" calcMode="spline" begin="0s"></animate>
    </circle><circle cx="50" cy="50" r="0" fill="none" stroke="#ff8f91" stroke-width="2">
    <animate attributeName="r" repeatCount="indefinite" dur="0.78125s" values="0;35" keyTimes="0;1" keySplines="0 0.2 0.8 1" calcMode="spline" begin="-0.390625s"></animate>
    <animate attributeName="opacity" repeatCount="indefinite" dur="0.78125s" values="1;0" keyTimes="0;1" keySplines="0.2 0 0.8 1" calcMode="spline" begin="-0.390625s"></animate>
    </circle>
</svg>
</div>
</div>
<!-- Loader Section End -->