<?php
header('Content-Type: application/json');
require __DIR__ . '/vendor/autoload.php'; // if using Composer for Brevo PHP SDK

use SendinBlue\ApiClient\Configuration;
use SendinBlue\Api\TransactionalEmailsApi;
use SendinBlue\Api\SMTPApi;
use GuzzleHttp\Client;

// Load environment variables
$apiKey = getenv('BREVO_API_KEY');

$name    = filter_input(INPUT_POST, 'name', FILTER_SANITIZE_STRING);
$email   = filter_input(INPUT_POST, 'email', FILTER_VALIDATE_EMAIL);
$message = filter_input(INPUT_POST, 'message', FILTER_SANITIZE_STRING);

if (!$name || !$email || !$message) {
    echo json_encode(['success' => false, 'error' => 'Invalid input.']);
    exit;
}

try {
    // Initialize Brevo client
    $config = Configuration::getDefaultConfiguration()->setApiKey('api-key', $apiKey);
    $apiInstance = new TransactionalEmailsApi(new Client(), $config);

    $sendSmtpEmail = new \SendinBlue\Model\SendSmtpEmail([
        'subject' => 'New Contact Message from ' . $name,
        'sender'  => ['name' => 'Fair E Support', 'email' => 'hello@faireweb.host'],
        'to'      => [[ 'email' => 'hello@fairewebhost.com', 'name' => 'Support Team' ]],
        'replyTo' => ['email' => $email, 'name' => $name],
        'htmlContent' => "<p><strong>Name:</strong> {$name}</p><p><strong>Email:</strong> {$email}</p><p><strong>Message:</strong><br>{$message}</p>"
    ]);

    $apiInstance->sendTransacEmail($sendSmtpEmail);

    echo json_encode(['success' => true]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}