<?php
require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/config.php';

$isLive = STRIPE_LIVE_MODE;
$stripeSecretKey = $isLive ? STRIPE_LIVE_SECRET : STRIPE_TEST_SECRET;
$allowedPrices   = $isLive ? json_decode(STRIPE_LIVE_PRICES, true) : json_decode(STRIPE_TEST_PRICES, true);

\Stripe\Stripe::setApiKey($stripeSecretKey);

$priceId = $_GET['price_id'] ?? '';
if (!array_key_exists($priceId, $allowedPrices)) {
    http_response_code(400);
    die("Invalid price.");
}

$domain = PLATFORM_DOMAIN;

try {
    $session = \Stripe\Checkout\Session::create([
        'payment_method_types' => ['card'],
        'line_items' => [[
            'price' => $priceId,
            'quantity' => 1,
        ]],
        'mode' => 'payment',
        'payment_intent_data' => [
            'capture_method' => 'manual',
        ],
        'success_url' => $domain . '/thank-you.php?session_id={CHECKOUT_SESSION_ID}',
        'cancel_url'  => $domain . '/cancelled.php',
    ]);
    header('Location: ' . $session->url);
    exit;
} catch (Exception $e) {
    echo "Stripe error: " . $e->getMessage();
    exit;
}